<?php

namespace App\Notifications;

use App\Models\Invoice;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class NewInvoiceNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(
        private Invoice $invoice
    ) {}

    public function via(object $notifiable): array
    {
        return ['database', 'mail'];
    }

    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('فاتورة جديدة - '.$this->invoice->invoice_number)
            ->greeting('مرحباً '.$notifiable->name)
            ->line('تم إصدار فاتورة جديدة برقم: '.$this->invoice->invoice_number)
            ->line('المبلغ الإجمالي: '.number_format($this->invoice->total_amount, 2).' ج.م')
            ->line('تاريخ الاستحقاق: '.$this->invoice->due_date->format('Y-m-d'))
            ->action('عرض الفاتورة', url('/customer/invoices/'.$this->invoice->id))
            ->line('شكراً لتعاملكم معنا!');
    }

    public function toArray(object $notifiable): array
    {
        return [
            'type' => 'new_invoice',
            'invoice_id' => $this->invoice->id,
            'invoice_number' => $this->invoice->invoice_number,
            'total_amount' => $this->invoice->total_amount,
            'message' => 'فاتورة جديدة برقم '.$this->invoice->invoice_number,
        ];
    }
}
