<?php

namespace App\Notifications;

use App\Models\Payment;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class PaymentReceivedNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(
        private Payment $payment
    ) {}

    public function via(object $notifiable): array
    {
        return ['database', 'mail'];
    }

    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('تأكيد استلام دفعة')
            ->greeting('مرحباً '.$notifiable->name)
            ->line('تم استلام دفعة بقيمة: '.number_format($this->payment->amount, 2).' ج.م')
            ->line('رقم العملية: '.$this->payment->transaction_id)
            ->line('طريقة الدفع: '.$this->payment->payment_method)
            ->action('عرض المدفوعات', url('/customer/invoices'))
            ->line('شكراً لتعاملكم معنا!');
    }

    public function toArray(object $notifiable): array
    {
        return [
            'type' => 'payment_received',
            'payment_id' => $this->payment->id,
            'amount' => $this->payment->amount,
            'transaction_id' => $this->payment->transaction_id,
            'message' => 'تم استلام دفعة بقيمة '.number_format($this->payment->amount, 2).' ج.م',
        ];
    }
}
