<?php

namespace App\Notifications;

use App\Models\Ticket;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class TicketCreatedNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(
        private Ticket $ticket
    ) {}

    public function via(object $notifiable): array
    {
        return ['database', 'mail'];
    }

    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('تذكرة دعم جديدة - '.$this->ticket->ticket_number)
            ->greeting('مرحباً '.$notifiable->name)
            ->line('تم إنشاء تذكرة دعم جديدة برقم: '.$this->ticket->ticket_number)
            ->line('الموضوع: '.$this->ticket->subject)
            ->action('عرض التذكرة', url('/admin/support/tickets/'.$this->ticket->id))
            ->line('سيتم الرد على استفسارك في أقرب وقت.');
    }

    public function toArray(object $notifiable): array
    {
        return [
            'type' => 'ticket_created',
            'ticket_id' => $this->ticket->id,
            'ticket_number' => $this->ticket->ticket_number,
            'subject' => $this->ticket->subject,
            'message' => 'تذكرة دعم جديدة: '.$this->ticket->subject,
        ];
    }
}
