<?php

namespace App\Observers;

use App\Models\AuditLog;
use Illuminate\Database\Eloquent\Model;

class AuditObserver
{
    public function created(Model $model)
    {
        $this->log($model, 'created', [], $model->toArray());
    }

    public function updated(Model $model)
    {
        $this->log($model, 'updated', $model->getOriginal(), $model->getChanges());
    }

    public function deleted(Model $model)
    {
        $this->log($model, 'deleted', $model->toArray(), []);
    }

    protected function log(Model $model, string $action, array $oldValues = [], array $newValues = [])
    {
        // Filter out hidden attributes if needed
        // For now, log everything except sensitive fields like password
        if (isset($newValues['password'])) {
            $newValues['password'] = '[HIDDEN]';
        }
        if (isset($oldValues['password'])) {
            $oldValues['password'] = '[HIDDEN]';
        }

        AuditLog::create([
            'user_id' => auth()->id(),
            'action' => $action,
            'model_type' => get_class($model),
            'model_id' => $model->id,
            'old_values' => $oldValues,
            'new_values' => $newValues,
            'ip_address' => request()->ip(),
            'user_agent' => request()->userAgent(),
        ]);
    }
}
