<?php

namespace App\Observers;

use App\Models\LeadActivity;

class LeadObserver
{
    /**
     * Handle the LeadActivity "created" event.
     */
    public function created(LeadActivity $leadActivity): void
    {
        $lead = $leadActivity->lead;

        if (! $lead) {
            return;
        }

        $points = match ($leadActivity->type) {
            'TEST_DRIVE' => 50,
            'MEETING' => 20,
            'QUOTE' => 30,
            'CALL' => 10,
            'EMAIL' => 5,
            'NOTE' => 2,
            default => 0,
        };

        if ($points > 0) {
            $oldScore = $lead->score;
            $lead->score += $points;
            $lead->save();

            // Check if score crossed 50 threshold
            if ($lead->score >= 50 && $oldScore < 50) {
                $lead->assignedTo?->notify(new \App\Notifications\HotLeadNotification($lead));
            }
        }
    }
}
