<?php

namespace App\Policies;

use App\Models\Invoice;
use App\Models\User;

class InvoicePolicy
{
    /**
     * Determine if the user can view the invoice.
     */
    public function view(User $user, Invoice $invoice): bool
    {
        // Admin roles can view any invoice
        if (in_array($user->role, ['SUPER_ADMIN', 'ADMIN', 'BRANCH_MANAGER', 'FINANCIAL_ACCOUNTANT'])) {
            return true;
        }

        // Customers can view their own invoices
        return $invoice->customer_id === $user->id;
    }

    /**
     * Determine if the user can update the invoice.
     */
    public function update(User $user, Invoice $invoice): bool
    {
        // Only draft/pending invoices can be edited
        if (! in_array($invoice->status, ['DRAFT', 'PENDING'])) {
            return false;
        }

        return in_array($user->role, ['SUPER_ADMIN', 'ADMIN', 'FINANCIAL_ACCOUNTANT']);
    }

    /**
     * Determine if the user can delete the invoice.
     */
    public function delete(User $user, Invoice $invoice): bool
    {
        // Only draft invoices can be deleted
        if ($invoice->status !== 'DRAFT') {
            return false;
        }

        return in_array($user->role, ['SUPER_ADMIN', 'ADMIN']);
    }
}
