<?php

namespace App\Policies;

use App\Models\JournalEntry;
use App\Models\User;

class JournalEntryPolicy
{
    /**
     * Determine if the user can approve the journal entry.
     * Enforces separation of duties: creator cannot approve their own entry.
     */
    public function approve(User $user, JournalEntry $entry): bool
    {
        // Only admin/financial roles can approve
        if (! in_array($user->role, ['SUPER_ADMIN', 'ADMIN', 'FINANCIAL_ACCOUNTANT'])) {
            return false;
        }

        // Creator cannot approve their own entry (separation of duties)
        return $entry->created_by !== $user->id;
    }

    /**
     * Determine if the user can delete the journal entry.
     */
    public function delete(User $user, JournalEntry $entry): bool
    {
        // Only draft entries can be deleted
        if ($entry->status !== 'DRAFT') {
            return false;
        }

        return in_array($user->role, ['SUPER_ADMIN', 'ADMIN', 'FINANCIAL_ACCOUNTANT']);
    }
}
