<?php

namespace App\Policies;

use App\Models\User;

class UserPolicy
{
    /**
     * Determine if the given user can create new users.
     */
    public function create(User $actor): bool
    {
        return in_array($actor->role, ['SUPER_ADMIN', 'ADMIN']);
    }

    /**
     * Determine if the given user can update the target user.
     */
    public function update(User $actor, User $target): bool
    {
        // Super admin can update anyone
        if ($actor->role === 'SUPER_ADMIN') {
            return true;
        }

        // Admin can update non-super-admin users
        if ($actor->role === 'ADMIN') {
            return $target->role !== 'SUPER_ADMIN';
        }

        // Users can update their own profile
        return $actor->id === $target->id;
    }

    /**
     * Determine if the given user can delete the target user.
     */
    public function delete(User $actor, User $target): bool
    {
        // Cannot self-delete
        if ($actor->id === $target->id) {
            return false;
        }

        // Only super admin can delete admin-level users
        if (in_array($target->role, ['SUPER_ADMIN', 'ADMIN'])) {
            return $actor->role === 'SUPER_ADMIN';
        }

        // Admin+ can delete non-admin users
        return in_array($actor->role, ['SUPER_ADMIN', 'ADMIN']);
    }
}
