<?php

namespace App\Services;

class VinDecoderService
{
    /**
     * Decode a VIN and return vehicle details.
     * 
     * @param string $vin
     * @return array
     */
    public function decode(string $vin): array
    {
        // In a real application, this would call an external API like NHTSA or similar.
        // For this implementation, we will mock the response.

        // Mock logic to determine Make based on VIN character
        $makes = [
            '1' => 'Chevrolet', 'J' => 'Toyota', 'W' => 'BMW', 
            'K' => 'Kia', 'H' => 'Honda', 'Z' => 'Ford'
        ];
        
        $firstChar = strtoupper(substr($vin, 0, 1));
        $make = $makes[$firstChar] ?? 'Unknown Make';

        return [
            'make' => $make,
            'model' => 'Model ' . substr($vin, 3, 2),
            'year' => 2000 + intval(substr($vin, 9, 1)) + (is_numeric(substr($vin, 9, 1)) ? 0 : 10), // Rough estimation
            'fuel_type' => 'Petrol',
            'transmission' => 'Automatic',
            'color' => 'White', // Default
            'features' => ['ABS', 'Airbags', 'Navigation'],
        ];
    }
}
