<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Company Information
    |--------------------------------------------------------------------------
    | Previously hardcoded in PublicController. Now centralized here for
    | easy maintenance and consistency across views.
    */

    'name' => 'الحمد للاستيراد وتجارة السيارات',
    'name_en' => 'Al-Hamd Import & Car Trading',
    'slogan' => 'الجيل القادم من عالم السيارات',
    'description' => 'الحمد للاستيراد وتجارة السيارات - الموزع المعتمد لسيارات تاتا موتورز في مصر. نقدم أحدث السيارات مع ضمان شامل وخدمة ما بعد البيع.',

    'stats' => [
        ['value' => '2500+', 'label' => 'عميل سعيد', 'description' => 'ثقة عملائنا هي سر نجاحنا'],
        ['value' => '15+', 'label' => 'موديل متاح', 'description' => 'تشكيلة واسعة تناسب جميع الاحتياجات'],
        ['value' => '8+', 'label' => 'سنوات خبرة', 'description' => 'خبرة طويلة في سوق السيارات المصري'],
        ['value' => '3+', 'label' => 'فروع', 'description' => 'نتوسع لخدمتكم بشكل أفضل'],
    ],

    'values' => [
        ['title' => 'الجودة والتميز', 'description' => 'نلتزم بأعلى معايير الجودة في كل ما نقدمه من سيارات وخدمات', 'icon' => 'fas fa-star'],
        ['title' => 'رضا العملاء', 'description' => 'عملاؤنا هم أولويتنا الأولى ونسعى دائماً لتجاوز توقعاتهم', 'icon' => 'fas fa-users'],
        ['title' => 'الشفافية والمصداقية', 'description' => 'نؤمن بالتعامل الشفاف والصادق مع جميع عملائنا', 'icon' => 'fas fa-handshake'],
        ['title' => 'الابتكار والتطوير', 'description' => 'نواكب أحدث التقنيات والحلول في عالم السيارات', 'icon' => 'fas fa-rocket'],
    ],

    'timeline' => [
        ['year' => '2025', 'title' => 'أسطول 5G للتأجير', 'description' => 'إطلاق خدمة تأجير السيارات الشاملة'],
        ['year' => '2024', 'title' => 'التوسع في مدن القناة', 'description' => 'افتتاح فروع جديدة في بورسعيد والإسماعيلية'],
        ['year' => '2020', 'title' => 'شراكة تاتا موتورز', 'description' => 'أصبحنا الموزع المعتمد رسمياً'],
        ['year' => '2015', 'title' => 'التأسيس', 'description' => 'بداية رحلة النجاح في عالم السيارات'],
    ],

    'social_media' => [
        'facebook' => env('SOCIAL_FACEBOOK', '#'),
        'instagram' => env('SOCIAL_INSTAGRAM', '#'),
        'twitter' => env('SOCIAL_TWITTER', '#'),
        'youtube' => env('SOCIAL_YOUTUBE', '#'),
        'whatsapp' => env('SOCIAL_WHATSAPP', '+201555767729'),
    ],
];
