$adminControllers = @("DashboardController", "UserController", "BranchController", "RoleController", "VehicleController", "BookingController", "FinanceController", "CrmController", "SupportController", "ContentController", "SettingsController")
$customerControllers = @("DashboardController", "ProfileController", "BookingController", "SupportController", "InvoiceController")
$publicControllers = @("HomeController", "VehicleController", "ServiceController", "ContactController", "PageController")

# Create Admin Controllers
foreach ($controller in $adminControllers) {
    Write-Host "Creating Admin Controller: $controller"
    php artisan make:controller Admin/$controller
}

# Create Customer Controllers
foreach ($controller in $customerControllers) {
    Write-Host "Creating Customer Controller: $controller"
    php artisan make:controller Customer/$controller
}

# Create Public Controllers
foreach ($controller in $publicControllers) {
    Write-Host "Creating Public Controller: $controller"
    php artisan make:controller $controller
}
