<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Vehicle>
 */
class VehicleFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'make' => 'Tata',
            'model' => $this->faker->word,
            'year' => $this->faker->year,
            'price' => $this->faker->numberBetween(500000, 2000000),
            'stock_number' => $this->faker->unique()->bothify('VIN-####-????'),
            'status' => 'AVAILABLE',
            'category' => $this->faker->randomElement(['SUV', 'Sedan', 'Commercial']),
            'mileage' => 0,
            'fuel_type' => 'Petrol',
            'transmission' => 'Automatic',
            'color' => $this->faker->colorName,
            'description' => $this->faker->sentence,
        ];
    }
}
