<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('vehicles', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('make');
            $table->string('model');
            $table->integer('year');
            $table->float('price');
            $table->integer('stock_quantity')->default(0);
            $table->string('stock_number')->unique();
            $table->string('vin')->nullable()->unique();
            $table->text('description')->nullable();
            $table->string('category'); // Enum VehicleCategory
            $table->string('fuel_type'); // Enum FuelType
            $table->string('transmission'); // Enum TransmissionType
            $table->integer('mileage')->nullable();
            $table->string('color')->nullable();
            $table->string('status')->default('AVAILABLE'); // Enum VehicleStatus
            $table->boolean('featured')->default(false);
            $table->uuid('branch_id')->nullable();
            $table->timestamps();

            $table->foreign('branch_id')->references('id')->on('branches')->nullOnDelete();
        });

        Schema::create('vehicle_images', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->uuid('vehicle_id');
            $table->string('image_url'); // Matches generic string length, or use text if very long
            $table->string('alt_text')->nullable();
            $table->boolean('is_primary')->default(false);
            $table->integer('order')->default(0);
            $table->timestamp('created_at')->useCurrent();

            $table->foreign('vehicle_id')->references('id')->on('vehicles')->onDelete('cascade');
        });

        Schema::create('vehicle_specifications', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->uuid('vehicle_id');
            $table->string('key');
            $table->string('label');
            $table->string('value');
            $table->string('category')->default('ENGINE'); // Enum VehicleSpecCategory
            $table->timestamps();

            $table->foreign('vehicle_id')->references('id')->on('vehicles')->onDelete('cascade');
        });

        Schema::create('vehicle_pricing', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->uuid('vehicle_id')->unique();
            $table->float('base_price');
            $table->float('discount_price')->nullable();
            $table->float('discount_percentage')->nullable();
            $table->float('taxes')->default(0);
            $table->float('fees')->default(0);
            $table->float('total_price');
            $table->string('currency')->default('EGP');
            $table->boolean('has_discount')->default(false);
            $table->dateTime('discount_expires')->nullable();
            $table->timestamps();

            $table->foreign('vehicle_id')->references('id')->on('vehicles')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('vehicle_pricing');
        Schema::dropIfExists('vehicle_specifications');
        Schema::dropIfExists('vehicle_images');
        Schema::dropIfExists('vehicles');
    }
};
