<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('service_types', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('name');
            $table->text('description')->nullable();
            $table->integer('duration'); // Minutes
            $table->float('price')->nullable();
            $table->string('category'); // Enum ServiceCategory
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });

        Schema::create('time_slots', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->integer('day_of_week');
            $table->string('start_time');
            $table->string('end_time');
            $table->integer('max_bookings')->default(1);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });

        Schema::create('bookings', function (Blueprint $table) {
            // General Booking Table
            $table->uuid('id')->primary();
            $table->string('type'); // Enum BookingType
            $table->uuid('customer_id');
            $table->uuid('vehicle_id')->nullable();
            $table->uuid('service_type_id')->nullable();
            $table->dateTime('date');
            $table->string('time_slot');
            $table->string('status')->default('PENDING'); // Enum BookingStatus
            $table->text('notes')->nullable();
            $table->float('total_price')->nullable();
            $table->string('payment_status')->default('PENDING'); // Enum PaymentStatus
            $table->uuid('payment_id')->nullable();
            $table->boolean('reminder_sent')->default(false);
            $table->timestamps();

            $table->foreign('customer_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('vehicle_id')->references('id')->on('vehicles')->nullOnDelete();
            $table->foreign('service_type_id')->references('id')->on('service_types')->nullOnDelete();
        });

        Schema::create('service_bookings', function (Blueprint $table) {
            // Redundant or specific service booking table
            $table->uuid('id')->primary();
            $table->uuid('customer_id');
            $table->uuid('vehicle_id')->nullable();
            $table->uuid('service_type_id');
            $table->uuid('time_slot_id')->nullable();
            $table->dateTime('date');
            $table->string('time_slot');
            $table->string('status')->default('PENDING');
            $table->text('notes')->nullable();
            $table->float('total_price')->nullable();
            $table->string('payment_status')->default('PENDING');
            $table->uuid('payment_id')->nullable();
            $table->boolean('reminder_sent')->default(false);
            $table->timestamps();

            $table->foreign('customer_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('vehicle_id')->references('id')->on('vehicles')->nullOnDelete();
            $table->foreign('service_type_id')->references('id')->on('service_types')->onDelete('cascade');
            $table->foreign('time_slot_id')->references('id')->on('time_slots')->nullOnDelete();
        });

        Schema::create('test_drive_bookings', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->uuid('customer_id');
            $table->uuid('vehicle_id');
            $table->dateTime('date');
            $table->string('time_slot');
            $table->string('status')->default('PENDING');
            $table->string('payment_status')->default('PENDING');
            $table->text('notes')->nullable();
            $table->timestamps();

            $table->foreign('customer_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('vehicle_id')->references('id')->on('vehicles')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('test_drive_bookings');
        Schema::dropIfExists('service_bookings');
        Schema::dropIfExists('bookings');
        Schema::dropIfExists('time_slots');
        Schema::dropIfExists('service_types');
    }
};
