<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('customer_profiles', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->uuid('user_id')->unique();
            $table->string('segment')->default('LEAD'); // Enum CustomerSegment
            $table->string('lead_source')->nullable();
            $table->float('lead_value')->default(0);
            $table->float('lifetime_value')->default(0);
            $table->dateTime('last_contact_date')->nullable();
            $table->dateTime('next_follow_up')->nullable();
            $table->json('preferences')->nullable();
            $table->json('tags')->nullable();
            $table->text('notes')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();

            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
        });

        Schema::create('campaigns', function (Blueprint $table) {
            // 'marketing_campaigns' in Prisma map, 'campaigns' in model name usually
            $table->uuid('id')->primary();
            $table->string('name');
            $table->text('description')->nullable();
            $table->string('type'); // Enum CampaignType
            $table->string('status')->default('DRAFT'); // Enum CampaignStatus
            $table->json('target_audience')->nullable();
            $table->float('budget')->nullable();
            $table->dateTime('start_date')->nullable();
            $table->dateTime('end_date')->nullable();
            $table->uuid('created_by');
            $table->timestamps();

            $table->foreign('created_by')->references('id')->on('users');
        });

        Schema::create('leads', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('lead_number')->unique();
            $table->uuid('customer_id')->nullable();
            $table->string('first_name');
            $table->string('last_name')->nullable();
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->string('company')->nullable();
            $table->string('source')->default('WEBSITE'); // Enum LeadSource
            $table->uuid('campaign_id')->nullable();
            $table->string('status')->default('NEW');
            $table->string('priority')->default('MEDIUM');
            $table->float('estimated_value')->nullable();
            $table->uuid('assigned_to')->nullable();
            $table->timestamps();

            $table->foreign('customer_id')->references('id')->on('customer_profiles')->nullOnDelete();
            $table->foreign('campaign_id')->references('id')->on('campaigns')->nullOnDelete();
            $table->foreign('assigned_to')->references('id')->on('users')->nullOnDelete();
        });

        Schema::create('opportunities', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->uuid('customer_id');
            $table->string('title');
            $table->text('description')->nullable();
            $table->string('stage')->default('LEAD'); // Enum OpportunityStage
            $table->float('value')->default(0);
            $table->string('currency')->default('EGP');
            $table->integer('probability')->default(0);
            $table->dateTime('expected_close_date')->nullable();
            $table->uuid('vehicle_id')->nullable();
            $table->timestamps();

            $table->foreign('customer_id')->references('id')->on('customer_profiles')->onDelete('cascade');
            $table->foreign('vehicle_id')->references('id')->on('vehicles')->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('opportunities');
        Schema::dropIfExists('leads');
        Schema::dropIfExists('campaigns');
        Schema::dropIfExists('customer_profiles');
    }
};
