<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('support_tickets', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('ticket_number')->unique();
            $table->uuid('customer_id');
            $table->string('subject');
            $table->text('description');
            $table->string('category')->default('GENERAL'); // Enum TicketCategory
            $table->string('priority')->default('MEDIUM'); // Enum TicketPriority
            $table->string('status')->default('OPEN'); // Enum TicketStatus
            $table->uuid('assigned_to')->nullable();
            $table->uuid('assigned_by')->nullable();
            $table->dateTime('assigned_at')->nullable();
            $table->dateTime('resolved_at')->nullable();
            $table->text('resolution')->nullable();
            $table->uuid('resolution_by')->nullable();
            $table->uuid('branch_id')->nullable();
            $table->timestamps();

            $table->foreign('customer_id')->references('id')->on('users');
            $table->foreign('assigned_to')->references('id')->on('users')->nullOnDelete();
            $table->foreign('assigned_by')->references('id')->on('users')->nullOnDelete();
            $table->foreign('resolution_by')->references('id')->on('users')->nullOnDelete();
            $table->foreign('branch_id')->references('id')->on('branches')->nullOnDelete();
        });

        Schema::create('ticket_comments', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->uuid('ticket_id');
            $table->uuid('author_id');
            $table->text('content');
            $table->boolean('is_internal')->default(false);
            $table->json('attachments')->nullable();
            $table->timestamps();

            $table->foreign('ticket_id')->references('id')->on('support_tickets')->onDelete('cascade');
            $table->foreign('author_id')->references('id')->on('users');
        });

        Schema::create('complaints', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('complaint_number')->unique();
            $table->uuid('customer_id');
            $table->string('subject');
            $table->text('description');
            $table->string('category')->default('SERVICE'); // Enum ComplaintCategory
            $table->string('severity')->default('MEDIUM'); // Enum ComplaintSeverity
            $table->string('status')->default('RECEIVED'); // Enum ComplaintStatus
            $table->uuid('assigned_to')->nullable();
            $table->text('resolution')->nullable();
            $table->uuid('branch_id')->nullable();
            $table->timestamps();

            $table->foreign('customer_id')->references('id')->on('users');
            $table->foreign('assigned_to')->references('id')->on('users')->nullOnDelete();
            $table->foreign('branch_id')->references('id')->on('branches')->nullOnDelete();
        });

        Schema::create('complaint_follow_ups', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->uuid('complaint_id');
            $table->uuid('author_id');
            $table->text('content');
            $table->string('action'); // Enum FollowUpAction
            $table->dateTime('next_follow_up')->nullable();
            $table->timestamps();

            $table->foreign('complaint_id')->references('id')->on('complaints')->onDelete('cascade');
            $table->foreign('author_id')->references('id')->on('users');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('complaint_follow_ups');
        Schema::dropIfExists('complaints');
        Schema::dropIfExists('ticket_comments');
        Schema::dropIfExists('support_tickets');
    }
};
