<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (! Schema::hasColumn('vehicles', 'features')) {
            Schema::table('vehicles', function (Blueprint $table) {
                $table->json('features')->nullable()->after('featured');
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasColumn('vehicles', 'features')) {
            Schema::table('vehicles', function (Blueprint $table) {
                $table->dropColumn('features');
            });
        }
    }
};
