<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (! Schema::hasTable('company_infos')) {
            Schema::create('company_infos', function (Blueprint $table) {
                $table->id();
                $table->string('title')->default('مرحباً بك في الحمد للسيارات');
                $table->string('subtitle')->nullable();
                $table->text('description')->nullable();
                $table->string('image_url')->nullable();
                $table->json('features')->nullable();
                $table->json('cta_buttons')->nullable();
                $table->timestamps();
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('company_infos');
    }
};
