<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('users')) {
            Schema::table('users', function (Blueprint $table) {
                $table->index('name', 'users_name_idx');
                $table->index('phone', 'users_phone_idx');
                $table->index('role', 'users_role_idx');
            });
        }

        if (Schema::hasTable('invoices')) {
            Schema::table('invoices', function (Blueprint $table) {
                $table->index('invoice_number', 'invoices_number_idx');
                $table->index('status', 'invoices_status_idx');
                $table->index('payment_status', 'invoices_payment_status_idx');
                $table->index('customer_id', 'invoices_customer_idx');
            });
        }

        if (Schema::hasTable('support_tickets')) {
            Schema::table('support_tickets', function (Blueprint $table) {
                $table->index('ticket_number', 'tickets_number_idx');
                $table->index('subject', 'tickets_subject_idx');
                $table->index('status', 'tickets_status_idx');
                $table->index('priority', 'tickets_priority_idx');
                $table->index('customer_id', 'tickets_customer_idx');
            });
        }

        if (Schema::hasTable('complaints')) {
            Schema::table('complaints', function (Blueprint $table) {
                $table->index('complaint_number', 'complaints_number_idx');
                $table->index('subject', 'complaints_subject_idx');
                $table->index('status', 'complaints_status_idx');
                $table->index('customer_id', 'complaints_customer_idx');
            });
        }

        if (Schema::hasTable('vehicles')) {
            Schema::table('vehicles', function (Blueprint $table) {
                $table->index('make', 'vehicles_make_idx');
                $table->index('model', 'vehicles_model_idx');
                $table->index('status', 'vehicles_status_idx');
                $table->index('category', 'vehicles_category_idx');
            });
        }

        if (Schema::hasTable('payments')) {
            Schema::table('payments', function (Blueprint $table) {
                $table->index('transaction_id', 'payments_transaction_idx');
                $table->index('customer_id', 'payments_customer_idx');
                $table->index('invoice_id', 'payments_invoice_idx');
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasTable('users')) {
            Schema::table('users', function (Blueprint $table) {
                $table->dropIndex('users_name_idx');
                $table->dropIndex('users_phone_idx');
                $table->dropIndex('users_role_idx');
            });
        }

        if (Schema::hasTable('invoices')) {
            Schema::table('invoices', function (Blueprint $table) {
                $table->dropIndex('invoices_number_idx');
                $table->dropIndex('invoices_status_idx');
                $table->dropIndex('invoices_payment_status_idx');
                $table->dropIndex('invoices_customer_idx');
            });
        }

        if (Schema::hasTable('support_tickets')) {
            Schema::table('support_tickets', function (Blueprint $table) {
                $table->dropIndex('tickets_number_idx');
                $table->dropIndex('tickets_subject_idx');
                $table->dropIndex('tickets_status_idx');
                $table->dropIndex('tickets_priority_idx');
                $table->dropIndex('tickets_customer_idx');
            });
        }

        if (Schema::hasTable('complaints')) {
            Schema::table('complaints', function (Blueprint $table) {
                $table->dropIndex('complaints_number_idx');
                $table->dropIndex('complaints_subject_idx');
                $table->dropIndex('complaints_status_idx');
                $table->dropIndex('complaints_customer_idx');
            });
        }

        if (Schema::hasTable('vehicles')) {
            Schema::table('vehicles', function (Blueprint $table) {
                $table->dropIndex('vehicles_make_idx');
                $table->dropIndex('vehicles_model_idx');
                $table->dropIndex('vehicles_status_idx');
                $table->dropIndex('vehicles_category_idx');
            });
        }

        if (Schema::hasTable('payments')) {
            Schema::table('payments', function (Blueprint $table) {
                $table->dropIndex('payments_transaction_idx');
                $table->dropIndex('payments_customer_idx');
                $table->dropIndex('payments_invoice_idx');
            });
        }
    }
};
