<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('maintenance_usage_items', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->uuid('maintenance_record_id');
            $table->uuid('product_id')->nullable(); // Link to inventory
            $table->string('description')->nullable(); // For non-inventory items or labor
            $table->integer('quantity')->default(1);
            $table->decimal('unit_cost', 15, 2)->default(0);
            $table->decimal('total_cost', 15, 2)->default(0);
            $table->boolean('is_stock_deducted')->default(false); // Track if stock was already reduced
            $table->timestamps();

            $table->foreign('maintenance_record_id')->references('id')->on('maintenance_records')->onDelete('cascade');
            $table->foreign('product_id')->references('id')->on('products');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('maintenance_usage_items');
    }
};
