<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->string('bin_location')->nullable()->after('quantity');
        });

        Schema::table('goods_receipt_items', function (Blueprint $table) {
            $table->string('batch_number')->nullable()->after('quantity_received');
            $table->date('expiry_date')->nullable()->after('batch_number');
        });

        Schema::table('maintenance_usage_items', function (Blueprint $table) {
            $table->string('batch_number')->nullable()->after('quantity');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn('bin_location');
        });

        Schema::table('goods_receipt_items', function (Blueprint $table) {
            $table->dropColumn(['batch_number', 'expiry_date']);
        });

        Schema::table('maintenance_usage_items', function (Blueprint $table) {
            $table->dropColumn('batch_number');
        });
    }
};
