<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class AdminSeeder extends Seeder
{
    public function run(): void
    {
        $seedPassword = app()->environment(['local', 'testing'])
            ? env('SEED_DEFAULT_PASSWORD', 'password')
            : Str::random(32);

        if (! User::where('email', 'admin@elhamd.com')->exists()) {
            User::create([
                'id' => (string) Str::uuid(),
                'name' => 'Super Admin',
                'email' => 'admin@elhamd.com',
                'password' => Hash::make($seedPassword),
                'role' => 'SUPER_ADMIN', // using string for enum compatibility
                'is_active' => true,
                'email_verified_at' => now(),
            ]);
        }
    }
}
