<?php

namespace Database\Seeders;

use App\Models\Department;
use Illuminate\Database\Seeder;

class OrganizationSeeder extends Seeder
{
    public function run(): void
    {
        // Branches
        \App\Models\Branch::firstOrCreate(['code' => 'HQ'], [
            'name' => 'المقر الرئيسي', 'code' => 'HQ',
            'address' => 'القاهرة، مصر', 'phone' => '+201000000001', 'email' => 'hq@elhamd.com',
            'is_active' => true, 'currency' => 'EGP', 'timezone' => 'Africa/Cairo',
        ]);
        \App\Models\Branch::firstOrCreate(['code' => 'ALEX'], [
            'name' => 'فرع الإسكندرية', 'code' => 'ALEX',
            'address' => 'الإسكندرية، مصر', 'phone' => '+201000000002', 'email' => 'alex@elhamd.com',
            'is_active' => true, 'currency' => 'EGP', 'timezone' => 'Africa/Cairo',
        ]);

        // Departments
        $depts = ['الإدارة العامة', 'المبيعات', 'التسويق', 'المحاسبة', 'الموارد البشرية', 'خدمة العملاء', 'الصيانة', 'تكنولوجيا المعلومات'];
        foreach ($depts as $dept) {
            Department::firstOrCreate(['name' => $dept], ['name' => $dept, 'is_active' => true]);
        }

        // Positions (require department_id)
        $department = Department::first();
        if ($department) {
            $positions = ['مدير عام', 'مدير مبيعات', 'محاسب', 'فني صيانة', 'مندوب مبيعات', 'مسؤول تسويق', 'مسؤول موارد بشرية', 'مسؤول خدمة عملاء', 'مبرمج', 'مدير فرع'];
            foreach ($positions as $pos) {
                \App\Models\Position::firstOrCreate(
                    ['title' => $pos, 'department_id' => $department->id],
                    ['title' => $pos, 'department_id' => $department->id, 'level' => 'SENIOR', 'is_active' => true]
                );
            }
        }

        // Permissions
        $permissions = [
            ['name' => 'access_admin_panel', 'description' => 'الوصول للوحة الإدارة', 'category' => 'system'],
            ['name' => 'manage_users', 'description' => 'إدارة المستخدمين', 'category' => 'system'],
            ['name' => 'manage_invoices', 'description' => 'إدارة الفواتير', 'category' => 'finance'],
            ['name' => 'manage_bookings', 'description' => 'إدارة الحجوزات', 'category' => 'bookings'],
            ['name' => 'manage_vehicles', 'description' => 'إدارة المركبات', 'category' => 'vehicles'],
            ['name' => 'manage_hr', 'description' => 'إدارة الموارد البشرية', 'category' => 'hr'],
            ['name' => 'manage_reports', 'description' => 'عرض التقارير', 'category' => 'reports'],
            ['name' => 'manage_marketing', 'description' => 'إدارة التسويق', 'category' => 'marketing'],
            ['name' => 'manage_support', 'description' => 'إدارة الدعم الفني', 'category' => 'support'],
            ['name' => 'manage_settings', 'description' => 'إدارة الإعدادات', 'category' => 'system'],
        ];
        foreach ($permissions as $p) {
            \App\Models\Permission::firstOrCreate(['name' => $p['name']], $p);
        }
    }
}
