<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class ServiceTypesSeeder extends Seeder
{
    public function run(): void
    {
        $types = [
            ['name' => 'تغيير زيت', 'description' => 'تغيير زيت المحرك والفلتر', 'duration' => 30, 'price' => 250, 'category' => 'MAINTENANCE'],
            ['name' => 'فحص شامل', 'description' => 'فحص شامل للمركبة', 'duration' => 60, 'price' => 500, 'category' => 'INSPECTION'],
            ['name' => 'تظليل', 'description' => 'تظليل زجاج المركبة', 'duration' => 120, 'price' => 1500, 'category' => 'ACCESSORIES'],
            ['name' => 'غسيل كامل', 'description' => 'غسيل داخلي وخارجي', 'duration' => 45, 'price' => 150, 'category' => 'WASH'],
            ['name' => 'تلميع', 'description' => 'تلميع وبوليش كامل', 'duration' => 180, 'price' => 800, 'category' => 'WASH'],
            ['name' => 'صيانة فرامل', 'description' => 'فحص وتبديل الفرامل', 'duration' => 90, 'price' => 600, 'category' => 'MAINTENANCE'],
            ['name' => 'فحص كمبيوتر', 'description' => 'فحص بالكمبيوتر', 'duration' => 30, 'price' => 200, 'category' => 'INSPECTION'],
            ['name' => 'تبديل إطارات', 'description' => 'تبديل 4 إطارات', 'duration' => 60, 'price' => 2000, 'category' => 'MAINTENANCE'],
            ['name' => 'تجربة قيادة', 'description' => 'تجربة قيادة لمركبة جديدة', 'duration' => 30, 'price' => 0, 'category' => 'TEST_DRIVE'],
            ['name' => 'ترخيص', 'description' => 'خدمة ترخيص المركبة', 'duration' => 120, 'price' => 350, 'category' => 'GOVERNMENT'],
        ];

        foreach ($types as $type) {
            \App\Models\ServiceType::firstOrCreate(['name' => $type['name']], array_merge($type, [
                'id' => (string) Str::uuid(),
                'is_active' => true,
            ]));
        }
    }
}
