<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class UsersSeeder extends Seeder
{
    public function run(): void
    {
        $seedPassword = app()->environment(['local', 'testing'])
            ? env('SEED_DEFAULT_PASSWORD', 'password')
            : Str::random(32);

        $users = [
            ['name' => 'أحمد محمد', 'email' => 'ahmed@elhamd.com', 'role' => 'ADMIN', 'phone' => '+201111111111'],
            ['name' => 'محمد علي', 'email' => 'mohamed@elhamd.com', 'role' => 'SALES_MANAGER', 'phone' => '+201111111112'],
            ['name' => 'فاطمة حسن', 'email' => 'fatma@elhamd.com', 'role' => 'FINANCIAL_ACCOUNTANT', 'phone' => '+201111111113'],
            ['name' => 'يوسف إبراهيم', 'email' => 'youssef@elhamd.com', 'role' => 'EMPLOYEE', 'phone' => '+201111111114'],
            ['name' => 'مريم سعيد', 'email' => 'mariam@elhamd.com', 'role' => 'EMPLOYEE', 'phone' => '+201111111115'],
            ['name' => 'علي حسين', 'email' => 'ali.customer@elhamd.com', 'role' => 'CUSTOMER', 'phone' => '+201222222221'],
            ['name' => 'نور الدين', 'email' => 'nour@elhamd.com', 'role' => 'CUSTOMER', 'phone' => '+201222222222'],
            ['name' => 'سارة أحمد', 'email' => 'sara@elhamd.com', 'role' => 'CUSTOMER', 'phone' => '+201222222223'],
            ['name' => 'خالد عمر', 'email' => 'khaled@elhamd.com', 'role' => 'CUSTOMER', 'phone' => '+201222222224'],
            ['name' => 'هند محمود', 'email' => 'hend@elhamd.com', 'role' => 'CUSTOMER', 'phone' => '+201222222225'],
        ];

        foreach ($users as $u) {
            User::firstOrCreate(['email' => $u['email']], [
                'id' => (string) Str::uuid(),
                'name' => $u['name'],
                'email' => $u['email'],
                'password' => Hash::make($seedPassword),
                'role' => $u['role'],
                'phone' => $u['phone'],
                'is_active' => true,
                'email_verified_at' => now(),
            ]);
        }
    }
}
