import sqlite3
import json
import os

db_path = r'c:\Users\shoko\OneDrive\Desktop\Elhamd-main\Elhamd-Laravel\Elhamd-main\db\custom.db'

if not os.path.exists(db_path):
    print(f"Error: Database not found at {db_path}")
    exit(1)

try:
    conn = sqlite3.connect(db_path)
    conn.row_factory = sqlite3.Row
    cursor = conn.cursor()
    
    # Check tables
    cursor.execute("SELECT name FROM sqlite_master WHERE type='table';")
    tables = [row['name'] for row in cursor.fetchall()]
    print(f"Tables found: {tables}")

    if 'Vehicle' in tables:
        cursor.execute("SELECT * FROM Vehicle")
        vehicles = [dict(row) for row in cursor.fetchall()]
        print(json.dumps(vehicles, indent=2, default=str))
    else:
        print("Vehicle table not found.")

    conn.close()
except Exception as e:
    print(f"Error: {e}")
