<x-admin-layout>
    <div class="p-6">
        <h2 class="text-2xl font-bold text-white mb-6">سجل النشاط</h2>

        <div class="bg-gray-800 rounded-xl overflow-hidden">
            <table class="w-full text-right">
                <thead class="bg-gray-700">
                    <tr>
                        <th class="p-4 text-gray-300">التاريخ</th>
                        <th class="p-4 text-gray-300">المستخدم</th>
                        <th class="p-4 text-gray-300">الإجراء</th>
                        <th class="p-4 text-gray-300">الوصف</th>
                        <th class="p-4 text-gray-300">IP</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($logs as $log)
                        <tr class="border-t border-gray-700 hover:bg-gray-750">
                            <td class="p-4 text-gray-400 text-sm">{{ $log->created_at->format('Y-m-d H:i') }}</td>
                            <td class="p-4 text-white">{{ $log->user?->name ?? 'نظام' }}</td>
                            <td class="p-4">
                                <span class="px-2 py-1 rounded text-xs font-semibold
                                    {{ $log->action === 'created' ? 'bg-green-500/20 text-green-400' : '' }}
                                    {{ $log->action === 'updated' ? 'bg-blue-500/20 text-blue-400' : '' }}
                                    {{ $log->action === 'deleted' ? 'bg-red-500/20 text-red-400' : '' }}
                                    {{ $log->action === 'restored' ? 'bg-amber-500/20 text-amber-400' : '' }}">
                                    {{ $log->action }}
                                </span>
                            </td>
                            <td class="p-4 text-gray-300 text-sm">{{ $log->description }}</td>
                            <td class="p-4 text-gray-500 font-mono text-xs">{{ $log->ip_address }}</td>
                        </tr>
                    @empty
                        <tr><td colspan="5" class="p-8 text-center text-gray-500">لا توجد سجلات نشاط بعد</td></tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="mt-4">{{ $logs->links() }}</div>
    </div>
</x-admin-layout>
