<x-admin-layout>
    <div class="mb-6">
        <h2 class="text-2xl font-bold text-slate-800">إنشاء فاتورة شراء</h2>
        <p class="text-slate-500 text-sm">إنشاء فاتورة لأمر الشراء: {{ $purchaseOrder->order_number }}</p>
    </div>

    <form action="{{ route('admin.bills.store') }}" method="POST">
        @csrf
        <input type="hidden" name="purchase_order_id" value="{{ $purchaseOrder->id }}">
        <input type="hidden" name="supplier_id" value="{{ $purchaseOrder->supplier_id }}">

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Header Info -->
            <div class="lg:col-span-1 space-y-6">
                <div class="bg-white rounded-2xl shadow-sm border border-slate-100 p-6">
                    <h3 class="font-bold text-slate-800 mb-4 border-b pb-2">بيانات الفاتورة</h3>
                    
                    <div class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-slate-700 mb-2">المورد</label>
                            <input type="text" value="{{ $purchaseOrder->supplier->name }}" readonly class="w-full rounded-xl border-gray-200 bg-gray-50 text-slate-500">
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-slate-700 mb-2">رقم الفاتورة (من المورد) <span class="text-red-500">*</span></label>
                            <input type="text" name="bill_number" value="{{ old('bill_number') }}" required class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500">
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-slate-700 mb-2">تاريخ الإصدار <span class="text-red-500">*</span></label>
                            <input type="date" name="issue_date" value="{{ old('issue_date', date('Y-m-d')) }}" required class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500">
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-slate-700 mb-2">تاريخ الاستحقاق <span class="text-red-500">*</span></label>
                            <input type="date" name="due_date" value="{{ old('due_date', date('Y-m-d', strtotime('+30 days'))) }}" required class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500">
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-slate-700 mb-2">ملاحظات</label>
                            <textarea name="notes" rows="3" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500">{{ old('notes') }}</textarea>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Items -->
            <div class="lg:col-span-2 space-y-6">
                <div class="bg-white rounded-2xl shadow-sm border border-slate-100 p-6">
                    <h3 class="font-bold text-slate-800 mb-4 border-b pb-2">بنود الفاتورة</h3>
                    
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">الوصف / المنتج</th>
                                    <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase w-24">الكمية</th>
                                    <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase w-32">السعر</th>
                                    <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase w-32">الإجمالي</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-200">
                                @foreach($purchaseOrder->items as $index => $item)
                                    <tr>
                                        <td class="px-4 py-2">
                                            <input type="hidden" name="items[{{ $index }}][product_id]" value="{{ $item->product_id }}">
                                            <input type="text" name="items[{{ $index }}][description]" value="{{ $item->product->name ?? 'Item' }}" class="w-full text-sm rounded-lg border-gray-200 focus:border-blue-500 focus:ring-blue-500">
                                        </td>
                                        <td class="px-4 py-2">
                                            <input type="number" name="items[{{ $index }}][quantity]" value="{{ $item->quantity_ordered }}" min="1" class="w-full text-sm rounded-lg border-gray-200 focus:border-blue-500 focus:ring-blue-500 item-qty" onchange="calculateRowTotal(this)">
                                        </td>
                                        <td class="px-4 py-2">
                                            <input type="number" name="items[{{ $index }}][unit_price]" value="{{ $item->unit_price }}" step="0.01" class="w-full text-sm rounded-lg border-gray-200 focus:border-blue-500 focus:ring-blue-500 item-price" onchange="calculateRowTotal(this)">
                                        </td>
                                        <td class="px-4 py-2">
                                            <input type="number" name="items[{{ $index }}][total_price]" value="{{ $item->total_price }}" step="0.01" readonly class="w-full text-sm rounded-lg border-gray-200 bg-gray-50 item-total font-bold text-slate-700">
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr class="bg-slate-50 font-bold">
                                    <td colspan="3" class="px-4 py-3 text-right">الإجمالي الكلي:</td>
                                    <td class="px-4 py-3 text-blue-600" id="grand-total">0.00</td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>

                <div class="flex justify-end gap-4">
                    <a href="{{ route('admin.purchase-orders.show', $purchaseOrder->id) }}" class="px-6 py-2.5 rounded-xl border border-gray-200 text-gray-700 font-semibold hover:bg-gray-50 transition-colors">إلغاء</a>
                    <button type="submit" class="px-6 py-2.5 rounded-xl bg-blue-600 text-white font-semibold hover:bg-blue-700 transition-colors shadow-sm">
                        حفظ الفاتورة
                    </button>
                </div>
            </div>
        </div>
    </form>

    <script>
        function calculateRowTotal(element) {
            const row = element.closest('tr');
            const qty = parseFloat(row.querySelector('.item-qty').value) || 0;
            const price = parseFloat(row.querySelector('.item-price').value) || 0;
            const total = qty * price;
            row.querySelector('.item-total').value = total.toFixed(2);
            calculateGrandTotal();
        }

        function calculateGrandTotal() {
            let grandTotal = 0;
            document.querySelectorAll('.item-total').forEach(item => {
                grandTotal += parseFloat(item.value) || 0;
            });
            document.getElementById('grand-total').innerText = grandTotal.toFixed(2);
        }

        // Initial calculation
        document.addEventListener('DOMContentLoaded', calculateGrandTotal);
    </script>
</x-admin-layout>
