<x-admin-layout>
    <div class="mb-6 flex justify-between items-center">
        <div>
            <h2 class="text-2xl font-bold text-slate-800">تفاصيل الفاتورة: {{ $bill->bill_number }}</h2>
            <div class="flex items-center gap-2 mt-1">
                <span class="text-slate-500 text-sm">تاريخ الإصدار: {{ $bill->issue_date->format('Y-m-d') }}</span>
                <span class="text-slate-300">|</span>
                <span class="px-2 py-0.5 rounded text-xs font-bold {{ $bill->status == 'POSTED' ? 'bg-emerald-100 text-emerald-700' : 'bg-yellow-100 text-yellow-700' }}">
                    {{ $bill->status == 'POSTED' ? 'مرحلة' : 'مسودة' }}
                </span>
            </div>
        </div>
        <div class="flex gap-2">
            <a href="{{ route('admin.bills.index') }}" class="px-4 py-2 border border-slate-200 rounded-lg text-slate-600 hover:bg-slate-50 transition-colors">عودة</a>
            
            @if($bill->status == 'DRAFT')
                <form action="{{ route('bills.post', $bill->id) }}" method="POST" onsubmit="return confirm('هل أنت متأكد من ترحيل الفاتورة؟ سيتم إنشاء قيد محاسبي ولا يمكن التعديل بعدها.');">
                    @csrf
                    <button type="submit" class="px-4 py-2 bg-emerald-600 text-white rounded-lg hover:bg-emerald-700 transition-colors flex items-center gap-2 font-bold shadow-sm">
                        <x-icon name="Check" class="h-4 w-4" />
                        ترحيل الفاتورة
                    </button>
                </form>
            @endif

            <button onclick="window.print()" class="px-4 py-2 bg-slate-800 text-white rounded-lg hover:bg-slate-700 transition-colors flex items-center gap-2">
                <x-icon name="Printer" class="h-4 w-4" />
                طباعة
            </button>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Main Content -->
        <div class="lg:col-span-2 bg-white rounded-2xl shadow-sm border border-slate-100 p-6">
            <h3 class="font-bold text-slate-800 mb-4">بنود الفاتورة</h3>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">الوصف</th>
                            <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">الكمية</th>
                            <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">السعر</th>
                            <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">الإجمالي</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        @foreach($bill->items as $item)
                            <tr>
                                <td class="px-4 py-3 text-sm text-slate-700">{{ $item->description }}</td>
                                <td class="px-4 py-3 text-sm text-slate-700">{{ $item->quantity }}</td>
                                <td class="px-4 py-3 text-sm text-slate-700">{{ number_format($item->unit_price, 2) }}</td>
                                <td class="px-4 py-3 text-sm font-bold text-slate-900">{{ number_format($item->total_price, 2) }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr class="bg-slate-50">
                            <td colspan="3" class="px-4 py-3 text-right font-bold text-slate-700">الإجمالي الكلي</td>
                            <td class="px-4 py-3 font-bold text-blue-600 text-lg">{{ number_format($bill->total_amount, 2) }} ج.م</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="lg:col-span-1 space-y-6">
            <div class="bg-white rounded-2xl shadow-sm border border-slate-100 p-6">
                <h3 class="font-bold text-slate-800 mb-4 border-b pb-2">بيانات المورد</h3>
                <div class="space-y-3">
                    <div>
                        <span class="block text-xs text-slate-500">الاسم</span>
                        <span class="font-medium text-slate-900">{{ $bill->supplier->name }}</span>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-2xl shadow-sm border border-slate-100 p-6">
                <h3 class="font-bold text-slate-800 mb-4 border-b pb-2">معلومات أخرى</h3>
                <div class="space-y-3">
                    <div>
                        <span class="block text-xs text-slate-500">أمر الشراء المرتبط</span>
                        @if($bill->purchaseOrder)
                            <a href="{{ route('admin.purchase-orders.show', $bill->purchaseOrder->id) }}" class="text-blue-600 hover:underline">
                                {{ $bill->purchaseOrder->order_number }}
                            </a>
                        @else
                            <span class="text-sm text-slate-500">-</span>
                        @endif
                    </div>
                    <div>
                        <span class="block text-xs text-slate-500">تاريخ الاستحقاق</span>
                        <span class="text-sm text-slate-700">{{ $bill->due_date->format('Y-m-d') }}</span>
                    </div>
                    @if($bill->notes)
                        <div>
                            <span class="block text-xs text-slate-500">ملاحظات</span>
                            <div class="text-sm text-slate-600 bg-yellow-50 p-2 rounded mt-1 border border-yellow-100">
                                {{ $bill->notes }}
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
