<x-admin-layout>
    <x-slot name="header">
        Service Booking Details
    </x-slot>

    <div class="max-w-2xl mx-auto">
        <div class="bg-white shadow overflow-hidden sm:rounded-lg mb-6">
            <div class="px-4 py-5 sm:px-6 flex justify-between items-center">
                <h3 class="text-lg leading-6 font-medium text-gray-900">Booking #{{ $booking->id }}</h3>
                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                    {{ $booking->status === 'CONFIRMED' ? 'bg-green-100 text-green-800' : 
                       ($booking->status === 'PENDING' ? 'bg-yellow-100 text-yellow-800' : 
                       ($booking->status === 'COMPLETED' ? 'bg-blue-100 text-blue-800' : 'bg-red-100 text-red-800')) }}">
                    {{ $booking->status }}
                </span>
            </div>
            <div class="border-t border-gray-200 px-4 py-5 sm:p-0">
                <dl class="sm:divide-y sm:divide-gray-200">
                    <!-- Customer -->
                    <div class="py-4 sm:py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                        <dt class="text-sm font-medium text-gray-500">Customer</dt>
                        <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2">
                            {{ $booking->customer->name ?? 'Guest' }}<br>
                            <span class="text-gray-500">{{ $booking->customer->email ?? '' }}</span>
                        </dd>
                    </div>

                    <!-- Service Type -->
                    <div class="py-4 sm:py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                        <dt class="text-sm font-medium text-gray-500">Service Type</dt>
                        <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2">{{ $booking->serviceType->name ?? 'N/A' }}</dd>
                    </div>

                    <!-- Vehicle -->
                     <div class="py-4 sm:py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                        <dt class="text-sm font-medium text-gray-500">Vehicle (If Applicable)</dt>
                         <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2">
                            @if($booking->vehicle)
                                {{ $booking->vehicle->make }} {{ $booking->vehicle->model }} ({{ $booking->vehicle->year }})
                            @else
                                N/A
                            @endif
                        </dd>
                    </div>

                    <!-- Date & Time -->
                    <div class="py-4 sm:py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                        <dt class="text-sm font-medium text-gray-500">Date & Time</dt>
                        <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2">
                            {{ $booking->date->format('l, M d, Y') }} at {{ $booking->time_slot }}
                        </dd>
                    </div>

                     <!-- Notes -->
                    <div class="py-4 sm:py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                        <dt class="text-sm font-medium text-gray-500">Notes</dt>
                        <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2">{{ $booking->notes ?? 'No notes provided.' }}</dd>
                    </div>
                </dl>
            </div>
        </div>

        <div class="bg-white shadow sm:rounded-lg overflow-hidden mb-6">
            <div class="p-6 bg-white border-b border-gray-200">
                <h3 class="text-lg font-medium leading-6 text-gray-900 mb-4">Update Status</h3>
                <form method="POST" action="{{ route('admin.bookings.update', $booking->id) }}">
                    @csrf
                    @method('PUT')

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="status" class="block text-sm font-medium text-gray-700">Status</label>
                            <select name="status" id="status" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                <option value="PENDING" {{ $booking->status == 'PENDING' ? 'selected' : '' }}>Pending</option>
                                <option value="CONFIRMED" {{ $booking->status == 'CONFIRMED' ? 'selected' : '' }}>Confirmed</option>
                                <option value="COMPLETED" {{ $booking->status == 'COMPLETED' ? 'selected' : '' }}>Completed</option>
                                <option value="CANCELLED" {{ $booking->status == 'CANCELLED' ? 'selected' : '' }}>Cancelled</option>
                            </select>
                        </div>

                         <div>
                            <label for="time_slot" class="block text-sm font-medium text-gray-700">Time Slot</label>
                            <input type="text" name="time_slot" id="time_slot" value="{{ old('time_slot', $booking->time_slot) }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        </div>
                    </div>
                    
                    <div class="mt-4">
                        <label for="notes" class="block text-sm font-medium text-gray-700">Admin Notes</label>
                        <textarea name="notes" id="notes" rows="3" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">{{ old('notes', $booking->notes) }}</textarea>
                    </div>

                    <div class="mt-4 flex justify-end">
                        <button type="submit" class="bg-blue-600 border border-transparent rounded-md shadow-sm py-2 px-4 text-sm font-medium text-white hover:bg-blue-700 focus:outline-none">Update Booking</button>
                    </div>
                </form>
            </div>
        </div>

        <div class="flex justify-end">
            <a href="{{ route('admin.bookings.index') }}" class="text-gray-600 hover:text-gray-900">Back to List</a>
        </div>
    </div>
</x-admin-layout>
