<x-app-layout>
    <x-slot name="header"><h2 class="text-xl font-semibold text-gray-800">إضافة فرع جديد</h2></x-slot>
    <div class="py-6"><div class="max-w-3xl mx-auto px-4">
        <div class="bg-white rounded-lg shadow p-6">
            <form method="POST" action="{{ route('admin.branches.store') }}">
                @csrf
                <div class="grid grid-cols-2 gap-4">
                    <div><label class="block text-sm font-medium text-gray-700 mb-1">اسم الفرع</label><input type="text" name="name" required class="w-full rounded-lg border-gray-300 shadow-sm" value="{{ old('name') }}">@error('name')<p class="text-red-500 text-xs mt-1">{{ $message }}</p>@enderror</div>
                    <div><label class="block text-sm font-medium text-gray-700 mb-1">الكود</label><input type="text" name="code" required class="w-full rounded-lg border-gray-300 shadow-sm" value="{{ old('code') }}">@error('code')<p class="text-red-500 text-xs mt-1">{{ $message }}</p>@enderror</div>
                    <div class="col-span-2"><label class="block text-sm font-medium text-gray-700 mb-1">العنوان</label><input type="text" name="address" class="w-full rounded-lg border-gray-300 shadow-sm" value="{{ old('address') }}"></div>
                    <div><label class="block text-sm font-medium text-gray-700 mb-1">الهاتف</label><input type="tel" name="phone" class="w-full rounded-lg border-gray-300 shadow-sm" value="{{ old('phone') }}"></div>
                    <div><label class="block text-sm font-medium text-gray-700 mb-1">البريد الإلكتروني</label><input type="email" name="email" class="w-full rounded-lg border-gray-300 shadow-sm" value="{{ old('email') }}"></div>
                    <div><label class="block text-sm font-medium text-gray-700 mb-1">العملة</label><input type="text" name="currency" class="w-full rounded-lg border-gray-300 shadow-sm" value="{{ old('currency', 'EGP') }}"></div>
                    <div><label class="block text-sm font-medium text-gray-700 mb-1">المنطقة الزمنية</label><input type="text" name="timezone" class="w-full rounded-lg border-gray-300 shadow-sm" value="{{ old('timezone', 'Africa/Cairo') }}"></div>
                </div>
                <div class="mt-6 flex gap-3">
                    <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700">إنشاء</button>
                    <a href="{{ route('admin.branches.index') }}" class="bg-gray-200 text-gray-700 px-6 py-2 rounded-lg hover:bg-gray-300">إلغاء</a>
                </div>
            </form>
        </div>
    </div></div>
</x-app-layout>
