<x-app-layout>
    <x-slot name="header"><h2 class="text-xl font-semibold text-gray-800">تعديل الفرع: {{ $branch->name }}</h2></x-slot>
    <div class="py-6"><div class="max-w-3xl mx-auto px-4">
        <div class="bg-white rounded-lg shadow p-6">
            <form method="POST" action="{{ route('admin.branches.update', $branch) }}">
                @csrf @method('PUT')
                <div class="grid grid-cols-2 gap-4">
                    <div><label class="block text-sm font-medium text-gray-700 mb-1">اسم الفرع</label><input type="text" name="name" required class="w-full rounded-lg border-gray-300 shadow-sm" value="{{ old('name', $branch->name) }}"></div>
                    <div><label class="block text-sm font-medium text-gray-700 mb-1">الكود</label><input type="text" name="code" required class="w-full rounded-lg border-gray-300 shadow-sm" value="{{ old('code', $branch->code) }}"></div>
                    <div class="col-span-2"><label class="block text-sm font-medium text-gray-700 mb-1">العنوان</label><input type="text" name="address" class="w-full rounded-lg border-gray-300 shadow-sm" value="{{ old('address', $branch->address) }}"></div>
                    <div><label class="block text-sm font-medium text-gray-700 mb-1">الهاتف</label><input type="tel" name="phone" class="w-full rounded-lg border-gray-300 shadow-sm" value="{{ old('phone', $branch->phone) }}"></div>
                    <div><label class="block text-sm font-medium text-gray-700 mb-1">البريد الإلكتروني</label><input type="email" name="email" class="w-full rounded-lg border-gray-300 shadow-sm" value="{{ old('email', $branch->email) }}"></div>
                    <div><label class="block text-sm font-medium text-gray-700 mb-1">العملة</label><input type="text" name="currency" class="w-full rounded-lg border-gray-300 shadow-sm" value="{{ old('currency', $branch->currency) }}"></div>
                    <div><label class="block text-sm font-medium text-gray-700 mb-1">المنطقة الزمنية</label><input type="text" name="timezone" class="w-full rounded-lg border-gray-300 shadow-sm" value="{{ old('timezone', $branch->timezone) }}"></div>
                    <div class="col-span-2"><label class="flex items-center gap-2"><input type="checkbox" name="is_active" value="1" {{ $branch->is_active ? 'checked' : '' }} class="rounded border-gray-300 text-blue-600"><span class="text-sm text-gray-700">فرع نشط</span></label></div>
                </div>
                <div class="mt-6 flex gap-3">
                    <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700">تحديث</button>
                    <a href="{{ route('admin.branches.index') }}" class="bg-gray-200 text-gray-700 px-6 py-2 rounded-lg hover:bg-gray-300">إلغاء</a>
                </div>
            </form>
        </div>
    </div></div>
</x-app-layout>
