<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="text-xl font-semibold text-gray-800">الفروع</h2>
            <a href="{{ route('admin.branches.create') }}" class="bg-blue-600 text-white px-4 py-2 rounded-lg text-sm hover:bg-blue-700">+ إضافة فرع</a>
        </div>
    </x-slot>
    <div class="py-6"><div class="max-w-7xl mx-auto px-4">
        @if(session('success'))<div class="bg-green-50 border-r-4 border-green-500 p-4 mb-4 text-green-800 rounded">{{ session('success') }}</div>@endif
        <div class="bg-white rounded-lg shadow overflow-hidden">
            <table class="min-w-full divide-y divide-gray-200 text-sm">
                <thead class="bg-gray-50"><tr>
                    <th class="px-4 py-3 text-right font-medium text-gray-500">الكود</th>
                    <th class="px-4 py-3 text-right font-medium text-gray-500">الاسم</th>
                    <th class="px-4 py-3 text-right font-medium text-gray-500">العنوان</th>
                    <th class="px-4 py-3 text-right font-medium text-gray-500">الهاتف</th>
                    <th class="px-4 py-3 text-right font-medium text-gray-500">الحالة</th>
                    <th class="px-4 py-3 text-right font-medium text-gray-500">إجراءات</th>
                </tr></thead>
                <tbody class="divide-y divide-gray-200">
                @forelse($branches ?? [] as $branch)
                    <tr>
                        <td class="px-4 py-3 font-mono text-xs">{{ $branch->code }}</td>
                        <td class="px-4 py-3 font-medium">{{ $branch->name }}</td>
                        <td class="px-4 py-3 text-gray-500">{{ $branch->address ?? '-' }}</td>
                        <td class="px-4 py-3">{{ $branch->phone ?? '-' }}</td>
                        <td class="px-4 py-3"><span class="px-2 py-0.5 rounded text-xs {{ $branch->is_active ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">{{ $branch->is_active ? 'نشط' : 'غير نشط' }}</span></td>
                        <td class="px-4 py-3"><a href="{{ route('admin.branches.edit', $branch) }}" class="text-blue-600 hover:text-blue-800 text-sm">تعديل</a></td>
                    </tr>
                @empty
                    <tr><td colspan="6" class="px-4 py-8 text-center text-gray-400">لا توجد فروع</td></tr>
                @endforelse
                </tbody>
            </table>
        </div>
    </div></div>
</x-app-layout>
