<x-admin-layout>
    <div x-data="{ showModal: false }">
        <div class="mb-6 flex flex-col md:flex-row justify-between items-center gap-4">
            <div>
                <h2 class="text-2xl font-bold text-slate-800">جدول المواعيد</h2>
                <p class="text-slate-500 text-sm">إدارة المواعيد والمهام والاجتماعات</p>
            </div>
            <div>
                 <button @click="showModal = true" class="inline-flex items-center gap-2 px-6 py-2.5 bg-blue-600 text-white rounded-xl hover:bg-blue-700 transition-colors shadow-md hover:shadow-lg font-bold">
                    <x-icon name="Plus" class="h-5 w-5" />
                    <span>إضافة موعد جديد</span>
                </button>
            </div>
        </div>

        <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden">
             <div class="p-6 border-b border-slate-100 bg-slate-50/50 flex justify-between items-center">
                <h3 class="text-lg font-bold text-slate-800 flex items-center gap-2">
                    <x-icon name="Calendar" class="h-5 w-5 text-indigo-500" />
                    {{ now()->translatedFormat('F Y') }}
                </h3>
            </div>
            <div class="p-6">
                <div class="space-y-4">
                    @forelse($events as $event)
                        <div class="flex items-center p-4 bg-slate-50 rounded-xl border-r-4 {{ $event->type === 'meeting' ? 'border-blue-500' : ($event->type === 'deadline' ? 'border-red-500' : 'border-emerald-500') }} hover:bg-slate-100 transition-colors group">
                            <div class="flex-shrink-0 w-16 text-center border-l border-slate-200 pl-4">
                                <div class="text-xl font-bold text-slate-800">{{ $event->start_time->format('d') }}</div>
                                <div class="text-xs font-bold text-slate-500 uppercase">{{ $event->start_time->translatedFormat('M') }}</div>
                            </div>
                            <div class="mr-4 flex-1">
                                <div class="flex justify-between items-start">
                                    <div>
                                        <h4 class="text-base font-bold text-slate-900 group-hover:text-blue-600 transition-colors">{{ $event->title }}</h4>
                                        <div class="flex items-center gap-2 text-xs text-slate-500 mt-1">
                                            <x-icon name="Clock" class="h-3 w-3" />
                                            {{ $event->start_time->format('H:i') }} 
                                            {{ $event->end_time ? '- ' . $event->end_time->format('H:i') : '' }}
                                        </div>
                                    </div>
                                    <span class="text-xs font-bold px-2 py-1 rounded bg-white text-slate-600 border border-slate-100 shadow-sm">
                                        {{ match($event->type) {
                                            'meeting' => 'اجتماع',
                                            'deadline' => 'موعيد نهائي',
                                            'event' => 'حدث',
                                            default => 'أخرى'
                                        } }}
                                    </span>
                                </div>
                                @if($event->description)
                                    <p class="text-sm text-slate-600 mt-2 line-clamp-1">{{ Str::limit($event->description, 100) }}</p>
                                @endif
                            </div>
                        </div>
                    @empty
                        <div class="text-center py-12 text-slate-500">
                             <div class="flex flex-col items-center gap-2">
                                <x-icon name="Calendar" class="h-10 w-10 text-slate-300" />
                                <p>لا توجد مواعيد لهذا الشهر.</p>
                            </div>
                        </div>
                    @endforelse
                </div>
            </div>
        </div>

        <!-- Add Event Modal -->
        <div x-show="showModal" 
             style="display: none;"
             class="fixed inset-0 z-50 overflow-y-auto" 
             aria-labelledby="modal-title" 
             role="dialog" 
             aria-modal="true">
            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                <div x-show="showModal" 
                     x-transition:enter="ease-out duration-300"
                     x-transition:enter-start="opacity-0"
                     x-transition:enter-end="opacity-100"
                     x-transition:leave="ease-in duration-200"
                     x-transition:leave-start="opacity-100"
                     x-transition:leave-end="opacity-0"
                     class="fixed inset-0 bg-slate-900/50 backdrop-blur-sm transition-opacity" 
                     @click="showModal = false"
                     aria-hidden="true"></div>

                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

                <div x-show="showModal" 
                     x-transition:enter="ease-out duration-300"
                     x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                     x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
                     x-transition:leave="ease-in duration-200"
                     x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
                     x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                     class="inline-block align-bottom bg-white rounded-2xl text-right overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg w-full">
                    
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <div class="sm:flex sm:items-start">
                            <div class="mx-auto flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-blue-100 sm:mx-0 sm:h-10 sm:w-10">
                                <x-icon name="CalendarPlus" class="h-6 w-6 text-blue-600" />
                            </div>
                            <div class="mt-3 text-center sm:mt-0 sm:mr-4 sm:text-right w-full">
                                <h3 class="text-lg leading-6 font-bold text-slate-800" id="modal-title">
                                    إضافة موعد جديد
                                </h3>
                                <div class="mt-4">
                                     <form id="createEventForm" method="POST" action="{{ route('admin.calendar.store') }}">
                                        @csrf
                                        <div class="space-y-4">
                                            <div>
                                                <label class="block text-sm font-bold text-slate-700 mb-1">العنوان</label>
                                                <input type="text" name="title" required class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800">
                                            </div>
                                            <div class="grid grid-cols-2 gap-4">
                                                <div>
                                                    <label class="block text-sm font-bold text-slate-700 mb-1">بداية الموعد</label>
                                                    <input type="datetime-local" name="start_time" required class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800">
                                                </div>
                                                <div>
                                                    <label class="block text-sm font-bold text-slate-700 mb-1">نهاية الموعد (اختياري)</label>
                                                    <input type="datetime-local" name="end_time" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800">
                                                </div>
                                            </div>
                                            <div>
                                                <label class="block text-sm font-bold text-slate-700 mb-1">النوع</label>
                                                <select name="type" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800">
                                                    <option value="meeting">اجتماع</option>
                                                    <option value="deadline">موعيد نهائي</option>
                                                    <option value="event">حدث</option>
                                                    <option value="other">أخرى</option>
                                                </select>
                                            </div>
                                            <div>
                                                <label class="block text-sm font-bold text-slate-700 mb-1">الوصف</label>
                                                <textarea name="description" rows="3" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800"></textarea>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="bg-slate-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse gap-2">
                        <button type="submit" form="createEventForm" class="w-full inline-flex justify-center rounded-xl border border-transparent shadow-sm px-4 py-2 bg-blue-600 text-base font-bold text-white hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 sm:ml-3 sm:w-auto sm:text-sm">
                            حفظ الموعد
                        </button>
                        <button type="button" @click="showModal = false" class="mt-3 w-full inline-flex justify-center rounded-xl border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-bold text-slate-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">
                            إلغاء
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
