<x-admin-layout>
    <div class="mb-6 flex flex-col md:flex-row justify-between items-center gap-4">
        <div>
            <h2 class="text-2xl font-bold text-slate-800">معلومات الشركة</h2>
            <p class="text-slate-500 text-sm">تعديل المعلومات التي تظهر في الصفحة الرئيسية وعن الشركة</p>
        </div>
        <div>
            <button type="submit" form="company-info-form" class="inline-flex items-center gap-2 px-6 py-2.5 bg-blue-600 text-white rounded-xl hover:bg-blue-700 transition-colors shadow-md hover:shadow-lg font-bold">
                <x-icon name="Check" class="h-5 w-5" />
                <span>حفظ التغييرات</span>
            </button>
        </div>
    </div>

    <div class="max-w-4xl mx-auto">
        <form id="company-info-form" action="{{ route('admin.cms.company-info.update') }}" method="POST" enctype="multipart/form-data" class="space-y-6">
            @csrf
            @method('PUT')

            <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden">
                <div class="p-6 border-b border-slate-100 bg-slate-50/50">
                    <h3 class="text-lg font-bold text-slate-800 flex items-center gap-2">
                        <x-icon name="DocumentText" class="h-5 w-5 text-blue-500" />
                        المعلومات الأساسية
                    </h3>
                </div>
                <div class="p-6 space-y-6">
                    <div class="grid grid-cols-1 gap-6">
                        <!-- Basic Info -->
                        <div>
                            <label class="block text-sm font-bold text-slate-700 mb-2">العنوان الرئيسي</label>
                            <input type="text" name="title" value="{{ $info->title }}" required 
                                   class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800">
                        </div>

                        <div>
                            <label class="block text-sm font-bold text-slate-700 mb-2">العنوان الفرعي</label>
                            <input type="text" name="subtitle" value="{{ $info->subtitle }}" 
                                   class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800">
                        </div>

                        <div>
                            <label class="block text-sm font-bold text-slate-700 mb-2">الوصف</label>
                            <textarea name="description" rows="4" 
                                      class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800">{{ $info->description }}</textarea>
                        </div>

                        <!-- Image -->
                        <div>
                            <label class="block text-sm font-bold text-slate-700 mb-2">صورة الواجهة (Hero Image)</label>
                            <div class="flex items-start gap-6">
                                <div class="flex-1">
                                    <input type="file" name="image_url" 
                                           class="block w-full text-sm text-slate-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100 transition-colors">
                                    <p class="text-xs text-slate-500 mt-2">اترك الحقل فارغاً للإبقاء على الصورة الحالية.</p>
                                </div>
                                @if($info->image_url)
                                    <div class="relative group">
                                        <img src="{{ Str::startsWith($info->image_url, 'http') ? $info->image_url : asset($info->image_url) }}" 
                                             alt="Current Image" class="h-24 w-auto object-cover rounded-lg border border-slate-200 shadow-sm">
                                        <div class="absolute inset-0 bg-black/50 rounded-lg opacity-0 group-hover:opacity-100 transition-opacity flex items-center justify-center text-white text-xs">
                                            المعاينة
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden">
                <div class="p-6 border-b border-slate-100 bg-slate-50/50">
                    <h3 class="text-lg font-bold text-slate-800 flex items-center gap-2">
                        <x-icon name="ListBullet" class="h-5 w-5 text-indigo-500" />
                        المميزات (نقاط)
                    </h3>
                </div>
                <div class="p-6">
                    <div id="features-container" class="space-y-3">
                        @php $features = $info->features ?? []; @endphp
                        @for($i = 0; $i < 5; $i++)
                            <div class="relative">
                                <span class="absolute right-3 top-1/2 -translate-y-1/2 text-slate-400 font-bold text-xs">{{ $i+1 }}</span>
                                <input type="text" name="features[]" value="{{ $features[$i] ?? '' }}" placeholder="الميزة رقم {{ $i+1 }}" 
                                       class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800 pr-8">
                            </div>
                        @endfor
                    </div>
                    <p class="text-xs text-slate-500 mt-3">أدخل حتى 5 مميزات رئيسية للشركة.</p>
                </div>
            </div>

            <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden">
                <div class="p-6 border-b border-slate-100 bg-slate-50/50">
                    <h3 class="text-lg font-bold text-slate-800 flex items-center gap-2">
                        <x-icon name="CursorArrowRays" class="h-5 w-5 text-amber-500" />
                        أزرار الدعوة لاتخاذ إجراء (CTA)
                    </h3>
                </div>
                <div class="p-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- CTA 1 -->
                        <div class="space-y-4 p-4 bg-slate-50 rounded-xl border border-slate-100">
                            <h4 class="text-sm font-bold text-slate-700 border-b border-slate-200 pb-2">الزر الأول (الرئيسي)</h4>
                            <div>
                                <label class="block text-xs font-bold text-slate-500 mb-1">نص الزر</label>
                                <input type="text" name="cta_text_1" value="{{ $info->cta_buttons[0]['text'] ?? '' }}" 
                                       class="w-full rounded-lg border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-sm">
                            </div>
                            <div>
                                <label class="block text-xs font-bold text-slate-500 mb-1">الرابط</label>
                                <input type="text" name="cta_link_1" value="{{ $info->cta_buttons[0]['link'] ?? '' }}" 
                                       class="w-full rounded-lg border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-sm ltr:text-left" dir="ltr">
                            </div>
                        </div>

                        <!-- CTA 2 -->
                        <div class="space-y-4 p-4 bg-slate-50 rounded-xl border border-slate-100">
                            <h4 class="text-sm font-bold text-slate-700 border-b border-slate-200 pb-2">الزر الثاني (الثانوي)</h4>
                            <div>
                                <label class="block text-xs font-bold text-slate-500 mb-1">نص الزر</label>
                                <input type="text" name="cta_text_2" value="{{ $info->cta_buttons[1]['text'] ?? '' }}" 
                                       class="w-full rounded-lg border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-sm">
                            </div>
                            <div>
                                <label class="block text-xs font-bold text-slate-500 mb-1">الرابط</label>
                                <input type="text" name="cta_link_2" value="{{ $info->cta_buttons[1]['link'] ?? '' }}" 
                                       class="w-full rounded-lg border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-sm ltr:text-left" dir="ltr">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</x-admin-layout>
