<x-admin-layout>
    <div class="mb-6 flex flex-col md:flex-row justify-between items-center gap-4">
        <div>
            <h2 class="text-2xl font-bold text-slate-800">بيانات التواصل</h2>
            <p class="text-slate-500 text-sm">إدارة ارقام الهاتف والبريد الإلكتروني والعنوان</p>
        </div>
        <div>
            <button type="submit" form="contact-form" class="inline-flex items-center gap-2 px-6 py-2.5 bg-blue-600 text-white rounded-xl hover:bg-blue-700 transition-colors shadow-md hover:shadow-lg font-bold">
                <x-icon name="Check" class="h-5 w-5" />
                <span>حفظ المعلومات</span>
            </button>
        </div>
    </div>

    <div class="max-w-4xl mx-auto">
         <form id="contact-form" action="{{ route('admin.cms.contact.update') }}" method="POST">
            @csrf
            
            <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden">
                <div class="p-6 border-b border-slate-100 bg-slate-50/50">
                    <h3 class="text-lg font-bold text-slate-800 flex items-center gap-2">
                        <x-icon name="Phone" class="h-5 w-5 text-blue-500" />
                        تفاصيل الاتصال والعنوان
                    </h3>
                </div>
                <div class="p-6 space-y-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-bold text-slate-700 mb-2">رقم الهاتف</label>
                            <input type="text" name="phone" value="{{ $contact->phone ?? '' }}" 
                                   class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800 ltr:text-left" dir="ltr">
                        </div>
                        <div>
                             <label class="block text-sm font-bold text-slate-700 mb-2">البريد الإلكتروني</label>
                            <input type="email" name="email" value="{{ $contact->email ?? '' }}" 
                                   class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800 ltr:text-left">
                        </div>
                        <div class="md:col-span-2">
                            <label class="block text-sm font-bold text-slate-700 mb-2">العنوان</label>
                            <input type="text" name="address" value="{{ $contact->address ?? '' }}" 
                                   class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800">
                        </div>
                         <div class="md:col-span-2">
                            <label class="block text-sm font-bold text-slate-700 mb-2">رابط الخريطة (Google Maps URL)</label>
                            <input type="text" name="map_url" value="{{ $contact->map_url ?? '' }}" 
                                   class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800 ltr:text-left" dir="ltr">
                            <p class="text-xs text-slate-500 mt-2">انسخ رابط "Embed Map" أو رابط الموقع من Google Maps.</p>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</x-admin-layout>
