<x-admin-layout>
    <div class="mb-6 flex flex-col md:flex-row justify-between items-center gap-4">
        <div>
            <h2 class="text-2xl font-bold text-slate-800">تعديل السؤال</h2>
            <p class="text-slate-500 text-sm">تعديل بيانات السؤال والإجابة</p>
        </div>
        <div>
            <a href="{{ route('admin.cms.faqs.index') }}" class="inline-flex items-center gap-2 px-4 py-2 bg-white border border-slate-200 rounded-xl hover:bg-slate-50 transition-colors shadow-sm font-bold text-slate-700">
                <x-icon name="ArrowRight" class="h-4 w-4" />
                <span>عودة للقائمة</span>
            </a>
        </div>
    </div>

    <div class="max-w-4xl mx-auto">
        <form action="{{ route('admin.cms.faqs.update', $faq->id) }}" method="POST">
            @csrf
            @method('PUT')
            
            <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden">
                <div class="p-6 border-b border-slate-100 bg-slate-50/50">
                    <h3 class="text-lg font-bold text-slate-800 flex items-center gap-2">
                        <x-icon name="PencilSquare" class="h-5 w-5 text-blue-500" />
                        بيانات السؤال
                    </h3>
                </div>
                <div class="p-6 space-y-6">
                    <div class="grid grid-cols-1 gap-6">
                        <div>
                            <label class="block text-sm font-bold text-slate-700 mb-2">السؤال</label>
                            <input type="text" name="question" value="{{ $faq->question }}" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800" required>
                        </div>
                        <div>
                            <label class="block text-sm font-bold text-slate-700 mb-2">الإجابة</label>
                            <textarea name="answer" rows="4" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800" required>{{ $faq->answer }}</textarea>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-bold text-slate-700 mb-2">القسم (التصنيف)</label>
                                <select name="category" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800">
                                    <option value="General" {{ $faq->category == 'General' ? 'selected' : '' }}>عام</option>
                                    <option value="Vehicles" {{ $faq->category == 'Vehicles' ? 'selected' : '' }}>المركبات</option>
                                    <option value="Maintenance" {{ $faq->category == 'Maintenance' ? 'selected' : '' }}>الصيانة</option>
                                    <option value="Finance" {{ $faq->category == 'Finance' ? 'selected' : '' }}>المالية</option>
                                    <option value="Procedures" {{ $faq->category == 'Procedures' ? 'selected' : '' }}>الإجراءات</option>
                                </select>
                            </div>
                            <div>
                                <label class="block text-sm font-bold text-slate-700 mb-2">الترتيب</label>
                                <input type="number" name="order" value="{{ $faq->order }}" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800">
                            </div>
                        </div>
                        <div>
                            <label class="inline-flex items-center gap-2 cursor-pointer">
                                <input type="checkbox" name="is_active" value="1" {{ $faq->is_active ? 'checked' : '' }} class="rounded border-gray-300 text-blue-600 shadow-sm focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50 h-5 w-5">
                                <span class="text-sm font-bold text-slate-700">نشط (يظهر في الموقع)</span>
                            </label>
                        </div>
                    </div>
                </div>
                <div class="p-6 bg-slate-50 border-t border-slate-100 flex justify-end gap-3">
                    <a href="{{ route('admin.cms.faqs.index') }}" class="inline-flex items-center px-4 py-2 bg-white border border-slate-300 rounded-xl font-bold text-xs text-slate-700 uppercase tracking-widest hover:bg-slate-50 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 transition ease-in-out duration-150">
                        إلغاء
                    </a>
                    <button type="submit" class="inline-flex items-center px-6 py-2 bg-blue-600 border border-transparent rounded-xl font-bold text-xs text-white uppercase tracking-widest hover:bg-blue-700 focus:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 transition ease-in-out duration-150">
                        <x-icon name="Check" class="h-4 w-4 ml-2" />
                        حفظ التعديلات
                    </button>
                </div>
            </div>
        </form>
    </div>
</x-admin-layout>
