<x-admin-layout>
    <div x-data="{ showModal: false }">
        <div class="mb-6 flex flex-col md:flex-row justify-between items-center gap-4">
            <div>
                <h2 class="text-2xl font-bold text-slate-800">قاعدة المعرفة</h2>
                <p class="text-slate-500 text-sm">إدارة أقسام ومقالات قاعدة المعرفة</p>
            </div>
            <div>
                 <button @click="showModal = true" class="inline-flex items-center gap-2 px-6 py-2.5 bg-blue-600 text-white rounded-xl hover:bg-blue-700 transition-colors shadow-md hover:shadow-lg font-bold">
                    <x-icon name="Plus" class="h-5 w-5" />
                    <span>إضافة قسم جديد</span>
                </button>
            </div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            @forelse($categories as $category)
                <div class="bg-white rounded-2xl shadow-sm border border-slate-100 p-6 hover:shadow-md transition-shadow">
                    <div class="flex justify-between items-start mb-4">
                        <div class="flex-1">
                            <h4 class="text-lg font-bold text-slate-800">{{ $category->name }}</h4>
                            <p class="text-sm text-slate-500 mt-1 line-clamp-2">{{ $category->description }}</p>
                        </div>
                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-lg text-xs font-bold bg-blue-50 text-blue-700 ml-2">
                            {{ $category->articles_count }} مقال
                        </span>
                    </div>
                    <div class="flex items-center justify-end gap-2 pt-4 border-t border-slate-50">
                        <a href="#" class="text-sm font-bold text-blue-600 hover:text-blue-700 flex items-center gap-1">
                            عرض المقالات
                            <x-icon name="ArrowLeft" class="h-4 w-4" />
                        </a>
                        <span class="text-slate-300">|</span>
                        <a href="#" class="text-sm font-bold text-slate-500 hover:text-slate-700">تعديل</a>
                    </div>
                </div>
            @empty
                <div class="col-span-full py-12 text-center bg-white rounded-2xl border border-slate-100 border-dashed">
                    <div class="flex flex-col items-center gap-2">
                        <x-icon name="Folder" class="h-12 w-12 text-slate-300" />
                        <h3 class="text-lg font-bold text-slate-800">لا توجد أقسام</h3>
                        <p class="text-slate-500">ابدأ بإضافة قسم جديد لقاعدة المعرفة</p>
                         <button @click="showModal = true" class="mt-4 inline-flex items-center gap-2 px-4 py-2 bg-blue-50 text-blue-600 rounded-lg hover:bg-blue-100 transition-colors font-bold text-sm">
                            <x-icon name="Plus" class="h-4 w-4" />
                            <span>إضافة قسم</span>
                        </button>
                    </div>
                </div>
            @endforelse
        </div>
        
        <div class="mt-8">
            {{ $categories->withQueryString()->links() }}
        </div>

        <!-- Create Category Modal -->
        <div x-show="showModal" 
             style="display: none;"
             class="fixed inset-0 z-50 overflow-y-auto" 
             aria-labelledby="modal-title" 
             role="dialog" 
             aria-modal="true">
            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                <div x-show="showModal" 
                     x-transition:enter="ease-out duration-300"
                     x-transition:enter-start="opacity-0"
                     x-transition:enter-end="opacity-100"
                     x-transition:leave="ease-in duration-200"
                     x-transition:leave-start="opacity-100"
                     x-transition:leave-end="opacity-0"
                     class="fixed inset-0 bg-slate-900/50 backdrop-blur-sm transition-opacity" 
                     @click="showModal = false"
                     aria-hidden="true"></div>

                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

                <div x-show="showModal" 
                     x-transition:enter="ease-out duration-300"
                     x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                     x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
                     x-transition:leave="ease-in duration-200"
                     x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
                     x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                     class="inline-block align-bottom bg-white rounded-2xl text-right overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg w-full">
                    
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <div class="sm:flex sm:items-start">
                            <div class="mx-auto flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-blue-100 sm:mx-0 sm:h-10 sm:w-10">
                                <x-icon name="FolderPlus" class="h-6 w-6 text-blue-600" />
                            </div>
                            <div class="mt-3 text-center sm:mt-0 sm:mr-4 sm:text-right w-full">
                                <h3 class="text-lg leading-6 font-bold text-slate-800" id="modal-title">
                                    إضافة قسم جديد
                                </h3>
                                <div class="mt-4">
                                    <form id="createCategoryForm" method="POST" action="{{ route('admin.cms.kb.category.store') }}">
                                        @csrf
                                        <div class="space-y-4">
                                            <div>
                                                <label class="block text-sm font-bold text-slate-700 mb-1">اسم القسم</label>
                                                <input type="text" name="name" required class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800">
                                            </div>
                                            <div>
                                                <label class="block text-sm font-bold text-slate-700 mb-1">الرابط (Slug)</label>
                                                <input type="text" name="slug" required class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800 ltr:text-left" dir="ltr">
                                            </div>
                                            <div>
                                                <label class="block text-sm font-bold text-slate-700 mb-1">الوصف</label>
                                                <textarea name="description" rows="3" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800"></textarea>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="bg-slate-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse gap-2">
                        <button type="submit" form="createCategoryForm" class="w-full inline-flex justify-center rounded-xl border border-transparent shadow-sm px-4 py-2 bg-blue-600 text-base font-bold text-white hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 sm:ml-3 sm:w-auto sm:text-sm">
                            حفظ القسم
                        </button>
                        <button type="button" @click="showModal = false" class="mt-3 w-full inline-flex justify-center rounded-xl border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-bold text-slate-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">
                            إلغاء
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
