<x-admin-layout>
    <div class="mb-6 flex flex-col md:flex-row justify-between items-center gap-4">
        <div>
            <h2 class="text-2xl font-bold text-slate-800">إدارة الخدمات والأسعار</h2>
            <p class="text-slate-500 text-sm">إضافة وتعديل قائمة الخدمات والأسعار</p>
        </div>
    </div>

    <div class="max-w-7xl mx-auto space-y-6">
        
        <!-- Add Service Item Form -->
        <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden">
             <div class="p-6 border-b border-slate-100 bg-slate-50/50">
                <h3 class="text-lg font-bold text-slate-800 flex items-center gap-2">
                    <x-icon name="PlusCircle" class="h-5 w-5 text-blue-500" />
                    إضافة خدمة جديدة
                </h3>
            </div>
            <div class="p-6">
                 <form action="{{ route('admin.cms.service-items.store') }}" method="POST">
                    @csrf
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-bold text-slate-700 mb-2">اسم الخدمة</label>
                            <input type="text" name="name" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800" placeholder="مثال: تغيير زيت المحرك" required>
                        </div>
                        <div>
                            <label class="block text-sm font-bold text-slate-700 mb-2">الفئة (اختياري)</label>
                            <input type="text" name="category" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800" placeholder="مثال: صيانة دورية">
                        </div>
                        <div>
                            <label class="block text-sm font-bold text-slate-700 mb-2">السعر</label>
                            <div class="relative">
                                <input type="number" step="0.01" name="price" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800 pl-16 pr-4" placeholder="0.00">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <span class="text-slate-500 font-bold bg-slate-100 px-2 py-1 rounded text-xs">ر.س</span>
                                </div>
                            </div>
                        </div>
                        <div>
                            <label class="block text-sm font-bold text-slate-700 mb-2">الترتيب</label>
                            <input type="number" name="order" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800" value="0">
                        </div>
                         <div class="md:col-span-2">
                            <label class="block text-sm font-bold text-slate-700 mb-2">الوصف</label>
                            <textarea name="description" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800" rows="2" placeholder="اكتب وصفاً مختصراً للخدمة..."></textarea>
                        </div>
                    </div>
                    <div class="mt-6 flex justify-end">
                         <button type="submit" class="inline-flex items-center gap-2 px-6 py-2.5 bg-blue-600 text-white rounded-xl hover:bg-blue-700 transition-colors shadow-md hover:shadow-lg font-bold">
                            <x-icon name="Plus" class="h-5 w-5" />
                            <span>إضافة الخدمة</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Existing Service Items List -->
        <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden">
            <div class="p-6 border-b border-slate-100 bg-slate-50/50">
                <h3 class="text-lg font-bold text-slate-800 flex items-center gap-2">
                    <x-icon name="ListBullet" class="h-5 w-5 text-indigo-500" />
                    قائمة الخدمات
                </h3>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full text-sm text-right">
                    <thead class="bg-slate-50 text-slate-600 font-bold border-b border-slate-100">
                        <tr>
                            <th class="px-6 py-4">اسم الخدمة</th>
                            <th class="px-6 py-4">الفئة</th>
                            <th class="px-6 py-4">السعر</th>
                            <th class="px-6 py-4 text-center">الإجراءات</th>
                        </tr>
                    </thead>
                     <tbody class="divide-y divide-slate-50">
                        @forelse($items as $item)
                        <tr class="hover:bg-slate-50/50 transition-colors">
                            <td class="px-6 py-4 font-bold text-slate-800">{{ $item->name }}</td>
                            <td class="px-6 py-4 text-slate-600">
                                @if($item->category)
                                    <span class="bg-blue-50 text-blue-700 px-2 py-1 rounded-lg text-xs font-bold">{{ $item->category }}</span>
                                @else
                                    -
                                @endif
                            </td>
                            <td class="px-6 py-4 font-bold text-emerald-600">{{ number_format($item->price, 2) }} ر.س</td>
                            <td class="px-6 py-4">
                                <div class="flex justify-center gap-2">
                                     <form action="{{ route('admin.cms.service-items.destroy', $item->id) }}" method="POST" onsubmit="return confirm('هل أنت متأكد من حذف هذه الخدمة؟');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="p-2 bg-red-50 text-red-600 rounded-lg hover:bg-red-100 transition-colors" title="حذف">
                                            <x-icon name="Trash" class="h-4 w-4" />
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="4" class="px-6 py-12 text-center text-slate-500">
                                <div class="flex flex-col items-center gap-2">
                                    <x-icon name="WrenchScrewdriver" class="h-10 w-10 text-slate-300" />
                                    <p>لا توجد خدمات مضافة حالياً.</p>
                                </div>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</x-admin-layout>
