<x-admin-layout>
    <div class="mb-6 flex flex-col md:flex-row justify-between items-center gap-4">
        <div>
            <h2 class="text-2xl font-bold text-slate-800">إعدادات الموقع</h2>
            <p class="text-slate-500 text-sm">تخصيص معلومات الموقع، الشعار، ووسائل التواصل</p>
        </div>
        <div>
            <button type="submit" form="settings-form" class="inline-flex items-center gap-2 px-6 py-2.5 bg-blue-600 text-white rounded-xl hover:bg-blue-700 transition-colors shadow-md hover:shadow-lg font-bold">
                <x-icon name="Check" class="h-5 w-5" />
                <span>حفظ التغييرات</span>
            </button>
        </div>
    </div>

    <div class="max-w-4xl mx-auto">
        @if(session('success'))
            <div class="bg-emerald-50 border border-emerald-200 text-emerald-700 px-4 py-3 rounded-xl mb-6 flex items-center gap-2">
                <x-icon name="CheckCircle" class="h-5 w-5" />
                <span>{{ session('success') }}</span>
            </div>
        @endif

        <form id="settings-form" method="POST" action="{{ route('admin.cms.settings.update') }}" class="space-y-6">
            @csrf
            
            {{-- General Information --}}
            <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden">
                <div class="p-6 border-b border-slate-100 bg-slate-50/50">
                    <h3 class="text-lg font-bold text-slate-800 flex items-center gap-2">
                        <x-icon name="Globe" class="h-5 w-5 text-blue-500" />
                        معلومات عامة
                    </h3>
                </div>
                <div class="p-6 space-y-6">
                    <div class="grid grid-cols-1 gap-6">
                        <div>
                            <label for="site_title" class="block text-sm font-bold text-slate-700 mb-2">اسم الموقع</label>
                            <input type="text" name="site_title" id="site_title" value="{{ $settings->site_title ?? config('app.name') }}" required 
                                   class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800">
                        </div>
                        <div>
                            <label for="site_description" class="block text-sm font-bold text-slate-700 mb-2">وصف الموقع</label>
                            <textarea name="site_description" id="site_description" rows="3" 
                                      class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800">{{ $settings->site_description ?? '' }}</textarea>
                            <p class="mt-2 text-xs text-slate-500">يظهر هذا الوصف في محركات البحث (SEO).</p>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Logo & Branding --}}
            <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden">
                <div class="p-6 border-b border-slate-100 bg-slate-50/50">
                    <h3 class="text-lg font-bold text-slate-800 flex items-center gap-2">
                        <x-icon name="Photo" class="h-5 w-5 text-purple-500" />
                        الشعار والعلامة التجارية
                    </h3>
                </div>
                <div class="p-6 space-y-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="logo_url" class="block text-sm font-bold text-slate-700 mb-2">رابط الشعار</label>
                            <div class="relative">
                                <input type="text" name="logo_url" id="logo_url" value="{{ $settings->logo_url ?? '' }}" placeholder="/uploads/logo/logo.png" 
                                       class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800 ltr:text-left" dir="ltr">
                            </div>
                            <p class="mt-2 text-xs text-slate-500">ادخل المسار النسبي للصورة من مجلد public</p>
                            @if($settings && $settings->logo_url)
                                <div class="mt-4 p-4 bg-slate-50 rounded-xl border border-slate-100 inline-block">
                                    <p class="text-xs font-bold text-slate-400 mb-2 uppercase tracking-wider">المعاينة</p>
                                    <img src="{{ asset($settings->logo_url) }}" alt="Logo Preview" class="h-12 object-contain">
                                </div>
                            @endif
                        </div>
                        <div>
                            <label for="favicon_url" class="block text-sm font-bold text-slate-700 mb-2">رابط الأيقونة (Favicon)</label>
                            <input type="text" name="favicon_url" id="favicon_url" value="{{ $settings->favicon_url ?? '' }}" 
                                   class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800 ltr:text-left" dir="ltr">
                        </div>
                    </div>
                </div>
            </div>

            {{-- Contact Information --}}
            <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden">
                <div class="p-6 border-b border-slate-100 bg-slate-50/50">
                    <h3 class="text-lg font-bold text-slate-800 flex items-center gap-2">
                        <x-icon name="Phone" class="h-5 w-5 text-green-500" />
                        معلومات التواصل
                    </h3>
                </div>
                <div class="p-6 space-y-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="contact_email" class="block text-sm font-bold text-slate-700 mb-2">البريد الإلكتروني</label>
                            <input type="email" name="contact_email" id="contact_email" value="{{ $settings->contact_email ?? '' }}" 
                                   class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800 ltr:text-left">
                        </div>
                        <div>
                            <label for="contact_phone" class="block text-sm font-bold text-slate-700 mb-2">رقم الهاتف</label>
                            <input type="text" name="contact_phone" id="contact_phone" value="{{ $settings->contact_phone ?? '' }}" 
                                   class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800 ltr:text-left" dir="ltr">
                        </div>
                        <div class="md:col-span-2">
                             <label for="contact_address" class="block text-sm font-bold text-slate-700 mb-2">العنوان</label>
                             <textarea name="contact_address" id="contact_address" rows="2" 
                                       class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800">{{ $settings->contact_address ?? '' }}</textarea>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Social Media Links --}}
            <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden">
                <div class="p-6 border-b border-slate-100 bg-slate-50/50">
                    <h3 class="text-lg font-bold text-slate-800 flex items-center gap-2">
                        <x-icon name="Share" class="h-5 w-5 text-indigo-500" />
                        روابط التواصل الاجتماعي
                    </h3>
                </div>
                <div class="p-6 space-y-6">
                    @php $socialLinks = is_array($settings->social_links ?? null) ? $settings->social_links : []; @endphp
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="social_facebook" class="block text-sm font-bold text-slate-700 mb-2">Facebook</label>
                            <div class="relative">
                                <span class="absolute left-3 top-1/2 -translate-y-1/2 text-slate-400">
                                    <i class="fab fa-facebook text-lg"></i>
                                </span>
                                <input type="url" name="social_links[facebook]" id="social_facebook" value="{{ $socialLinks['facebook'] ?? '' }}" placeholder="https://facebook.com/..." 
                                       class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800 pl-10 ltr:text-left" dir="ltr">
                            </div>
                        </div>
                        <div>
                            <label for="social_whatsapp" class="block text-sm font-bold text-slate-700 mb-2">WhatsApp</label>
                           <div class="relative">
                                <span class="absolute left-3 top-1/2 -translate-y-1/2 text-slate-400">
                                    <i class="fab fa-whatsapp text-lg"></i>
                                </span>
                                <input type="text" name="social_links[whatsapp]" id="social_whatsapp" value="{{ $socialLinks['whatsapp'] ?? '' }}" placeholder="https://wa.me/..." 
                                       class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800 pl-10 ltr:text-left" dir="ltr">
                            </div>
                        </div>
                        <div>
                            <label for="social_instagram" class="block text-sm font-bold text-slate-700 mb-2">Instagram</label>
                            <div class="relative">
                                <span class="absolute left-3 top-1/2 -translate-y-1/2 text-slate-400">
                                    <i class="fab fa-instagram text-lg"></i>
                                </span>
                                <input type="url" name="social_links[instagram]" id="social_instagram" value="{{ $socialLinks['instagram'] ?? '' }}" placeholder="https://instagram.com/..." 
                                       class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800 pl-10 ltr:text-left" dir="ltr">
                            </div>
                        </div>
                         <div>
                            <label for="social_linkedin" class="block text-sm font-bold text-slate-700 mb-2">LinkedIn</label>
                            <div class="relative">
                                <span class="absolute left-3 top-1/2 -translate-y-1/2 text-slate-400">
                                    <i class="fab fa-linkedin text-lg"></i>
                                </span>
                                <input type="url" name="social_links[linkedin]" id="social_linkedin" value="{{ $socialLinks['linkedin'] ?? '' }}" placeholder="https://linkedin.com/in/..." 
                                       class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800 pl-10 ltr:text-left" dir="ltr">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Appearance --}}
            <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden">
                <div class="p-6 border-b border-slate-100 bg-slate-50/50">
                    <h3 class="text-lg font-bold text-slate-800 flex items-center gap-2">
                        <x-icon name="Swatch" class="h-5 w-5 text-amber-500" />
                        المظهر
                    </h3>
                </div>
                <div class="p-6 space-y-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                         <div>
                            <label for="primary_color" class="block text-sm font-bold text-slate-700 mb-2">اللون الأساسي</label>
                            <div class="flex items-center gap-4">
                                <input type="color" name="primary_color" id="primary_color" value="{{ $settings->primary_color ?? '#2563eb' }}" 
                                       class="h-10 w-20 rounded cursor-pointer border-0 p-0">
                                <span class="text-sm text-slate-500 font-mono">{{ $settings->primary_color ?? '#2563eb' }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</x-admin-layout>
