<x-admin-layout>
    <div x-data="{ createSliderModalOpen: false }">
        <div class="mb-6 flex flex-col md:flex-row justify-between items-center gap-4">
            <div>
                <h2 class="text-2xl font-bold text-slate-800">شرائح العرض (Sliders)</h2>
                <p class="text-slate-500 text-sm">إدارة الصور والنصوص في الصفحة الرئيسية</p>
            </div>
            <button @click="createSliderModalOpen = true" class="inline-flex items-center gap-2 px-4 py-2 bg-blue-600 text-white rounded-xl hover:bg-blue-700 transition-colors shadow-sm font-semibold">
                <x-icon name="Plus" class="h-4 w-4" />
                <span>إضافة شريحة جديدة</span>
            </button>
        </div>

        <div class="overflow-hidden rounded-2xl bg-white shadow-sm border border-slate-100">
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50/50">
                        <tr>
                            <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">الصورة</th>
                            <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">العنوان</th>
                            <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">الترتيب</th>
                            <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">الحالة</th>
                            <th class="px-6 py-4 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">إجراءات</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @forelse($sliders as $slider)
                            <tr class="hover:bg-slate-50/50 transition-colors">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="h-16 w-24 rounded-lg overflow-hidden border border-slate-200">
                                        <img src="{{ $slider->image_url }}" alt="Slider" class="h-full w-full object-cover">
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-bold text-slate-900">{{ $slider->title }}</div>
                                    <div class="text-xs text-slate-500">{{ Str::limit($slider->subtitle, 40) }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-slate-600 font-mono">
                                    {{ $slider->order }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="px-3 py-1 inline-flex text-xs leading-5 font-bold rounded-full {{ $slider->is_active ? 'bg-emerald-100 text-emerald-700' : 'bg-red-100 text-red-700' }}">
                                        {{ $slider->is_active ? 'نشط' : 'غير نشط' }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-left text-sm font-medium flex items-center justify-end gap-2">
                                    <a href="#" class="p-2 bg-slate-100 text-slate-600 rounded-lg hover:bg-slate-200 transition-colors">
                                        <x-icon name="Edit" class="h-4 w-4" />
                                    </a>
                                    <button class="p-2 bg-red-50 text-red-600 rounded-lg hover:bg-red-100 transition-colors">
                                        <x-icon name="Trash" class="h-4 w-4" />
                                    </button>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="px-6 py-12 text-center text-slate-500">
                                    <div class="flex flex-col items-center justify-center">
                                        <div class="h-16 w-16 bg-slate-50 rounded-full flex items-center justify-center mb-4">
                                            <x-icon name="Image" class="h-8 w-8 text-slate-300" />
                                        </div>
                                        <p class="text-lg font-medium">لا توجد شرائح عرض</p>
                                        <p class="text-sm">أضف شرائح جديدة لعرضها في الصفحة الرئيسية.</p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <div class="border-t border-gray-100 bg-gray-50/50 p-4">
                {{ $sliders->withQueryString()->links() }}
            </div>
        </div>

        <!-- Create Slider Modal -->
        <div x-show="createSliderModalOpen" class="fixed inset-0 z-50 overflow-y-auto" style="display: none;">
            <div class="fixed inset-0 bg-gray-900/50 backdrop-blur-sm transition-opacity" @click="createSliderModalOpen = false"></div>

            <div class="flex min-h-full items-center justify-center p-4">
                <div class="relative w-full max-w-lg transform overflow-hidden rounded-2xl bg-white p-6 text-right shadow-xl transition-all">
                    <div class="flex items-center justify-between mb-6 border-b border-gray-100 pb-4">
                        <h3 class="text-xl font-bold text-slate-800">إضافة شريحة جديدة</h3>
                        <button @click="createSliderModalOpen = false" class="text-gray-400 hover:text-gray-500">
                            <x-icon name="X" class="h-6 w-6" />
                        </button>
                    </div>

                    <form method="POST" action="{{ route('admin.cms.sliders.store') }}" class="space-y-4">
                        @csrf
                        <div>
                            <label class="block text-sm font-medium text-slate-700 mb-1">العنوان الرئيسي</label>
                            <input type="text" name="title" required class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-slate-700 mb-1">العنوان الفرعي</label>
                            <input type="text" name="subtitle" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-slate-700 mb-1">رابط الصورة (URL)</label>
                            <div class="flex gap-2">
                                <input type="url" name="image_url" required class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500">
                                <button type="button" class="px-3 bg-slate-100 rounded-xl hover:bg-slate-200 text-slate-600">
                                    <x-icon name="Upload" class="h-5 w-5" />
                                </button>
                            </div>
                        </div>
                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-slate-700 mb-1">نص الزر</label>
                                <input type="text" name="button_text" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-slate-700 mb-1">رابط الزر</label>
                                <input type="url" name="button_link" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500">
                            </div>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-slate-700 mb-1">الترتيب</label>
                            <input type="number" name="order" value="0" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500">
                        </div>

                        <div class="mt-6 flex justify-end gap-3 pt-4 border-t border-gray-100">
                            <button type="button" @click="createSliderModalOpen = false" class="px-4 py-2 bg-slate-100 text-slate-700 rounded-xl hover:bg-slate-200 font-medium transition-colors">
                                إلغاء
                            </button>
                            <button type="submit" class="px-6 py-2 bg-blue-600 text-white rounded-xl hover:bg-blue-700 font-semibold shadow-sm transition-colors">
                                حفظ التغييرات
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
