<x-admin-layout>
    <div class="mb-6 flex flex-col md:flex-row justify-between items-center gap-4">
        <div>
            <h2 class="text-2xl font-bold text-slate-800">إدارة الجدول الزمني</h2>
            <p class="text-slate-500 text-sm">عرض محطات وتاريخ الشركة</p>
        </div>
    </div>

    <div class="max-w-7xl mx-auto space-y-6">
        
        <!-- Add Timeline Event Form -->
        <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden">
             <div class="p-6 border-b border-slate-100 bg-slate-50/50">
                <h3 class="text-lg font-bold text-slate-800 flex items-center gap-2">
                    <x-icon name="PlusCircle" class="h-5 w-5 text-blue-500" />
                    إضافة حدث جديد
                </h3>
            </div>
            <div class="p-6">
                <form action="{{ route('admin.cms.timeline.store') }}" method="POST">
                    @csrf
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-bold text-slate-700 mb-2">العنوان</label>
                            <input type="text" name="title" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800" placeholder="مثال: تأسيس الشركة" required>
                        </div>
                        <div>
                            <label class="block text-sm font-bold text-slate-700 mb-2">التاريخ (السنة/الشهر)</label>
                            <input type="date" name="event_date" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800" required>
                        </div>
                        <div class="md:col-span-2">
                            <label class="block text-sm font-bold text-slate-700 mb-2">الوصف</label>
                            <textarea name="description" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800" rows="3" placeholder="اكتب وصفاً للحدث..."></textarea>
                        </div>
                        <div>
                            <label class="block text-sm font-bold text-slate-700 mb-2">الترتيب</label>
                            <input type="number" name="order" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800" value="0">
                        </div>
                    </div>
                    <div class="mt-6 flex justify-end">
                         <button type="submit" class="inline-flex items-center gap-2 px-6 py-2.5 bg-blue-600 text-white rounded-xl hover:bg-blue-700 transition-colors shadow-md hover:shadow-lg font-bold">
                            <x-icon name="Plus" class="h-5 w-5" />
                            <span>إضافة حدث</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Timeline Events List -->
        <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden">
            <div class="p-6 border-b border-slate-100 bg-slate-50/50">
                <h3 class="text-lg font-bold text-slate-800 flex items-center gap-2">
                    <x-icon name="Clock" class="h-5 w-5 text-indigo-500" />
                    أحداث الجدول الزمني
                </h3>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full text-sm text-right">
                    <thead class="bg-slate-50 text-slate-600 font-bold border-b border-slate-100">
                        <tr>
                            <th class="px-6 py-4">التاريخ</th>
                            <th class="px-6 py-4">العنوان</th>
                            <th class="px-6 py-4">الوصف</th>
                            <th class="px-6 py-4 text-center">الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-50">
                        @forelse($events as $event)
                        <tr class="hover:bg-slate-50/50 transition-colors">
                            <td class="px-6 py-4 font-bold text-blue-600">{{ $event->event_date->format('Y-m-d') }}</td>
                            <td class="px-6 py-4 font-bold text-slate-800">{{ $event->title }}</td>
                            <td class="px-6 py-4 text-slate-600">{{ Str::limit($event->description, 50) }}</td>
                            <td class="px-6 py-4">
                                <div class="flex justify-center gap-2">
                                     <form action="{{ route('admin.cms.timeline.destroy', $event->id) }}" method="POST" onsubmit="return confirm('هل أنت متأكد من حذف هذا الحدث؟');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="p-2 bg-red-50 text-red-600 rounded-lg hover:bg-red-100 transition-colors" title="حذف">
                                            <x-icon name="Trash" class="h-4 w-4" />
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="4" class="px-6 py-12 text-center text-slate-500">
                                <div class="flex flex-col items-center gap-2">
                                    <x-icon name="Clock" class="h-10 w-10 text-slate-300" />
                                    <p>لا توجد أحداث مضافة حالياً.</p>
                                </div>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</x-admin-layout>
