<x-admin-layout>
    <div class="mb-6 flex flex-col md:flex-row justify-between items-center gap-4">
        <div>
            <h2 class="text-2xl font-bold text-slate-800">إدارة قيم الشركة</h2>
            <p class="text-slate-500 text-sm">عرض القيم والمبادئ الأساسية للشركة</p>
        </div>
    </div>

    <div class="max-w-7xl mx-auto space-y-6">
        
        <!-- Add New Value Form -->
        <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden">
             <div class="p-6 border-b border-slate-100 bg-slate-50/50">
                <h3 class="text-lg font-bold text-slate-800 flex items-center gap-2">
                    <x-icon name="PlusCircle" class="h-5 w-5 text-blue-500" />
                    إضافة قيمة جديدة
                </h3>
            </div>
            <div class="p-6">
                 <form action="{{ route('admin.cms.values.store') }}" method="POST">
                    @csrf
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-bold text-slate-700 mb-2">العنوان</label>
                            <input type="text" name="title" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800" placeholder="مثال: الجودة" required>
                        </div>
                        <div>
                            <label class="block text-sm font-bold text-slate-700 mb-2">الايقونة (FontAwesome)</label>
                            <div class="relative">
                                <input type="text" name="icon" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800 ltr:text-left pl-10" placeholder="fas fa-check" dir="ltr">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <i class="fas fa-icons text-slate-400"></i>
                                </div>
                            </div>
                        </div>
                        <div class="md:col-span-2">
                            <label class="block text-sm font-bold text-slate-700 mb-2">الوصف</label>
                            <textarea name="description" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800" rows="3" placeholder="اكتب وصفاً للقيمة..." required></textarea>
                        </div>
                        <div>
                            <label class="block text-sm font-bold text-slate-700 mb-2">الترتيب</label>
                            <input type="number" name="order" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-slate-800" value="0">
                        </div>
                    </div>
                    <div class="mt-6 flex justify-end">
                         <button type="submit" class="inline-flex items-center gap-2 px-6 py-2.5 bg-blue-600 text-white rounded-xl hover:bg-blue-700 transition-colors shadow-md hover:shadow-lg font-bold">
                            <x-icon name="Plus" class="h-5 w-5" />
                            <span>إضافة القيمة</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Existing Values List -->
        <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden">
            <div class="p-6 border-b border-slate-100 bg-slate-50/50">
                <h3 class="text-lg font-bold text-slate-800 flex items-center gap-2">
                    <x-icon name="Star" class="h-5 w-5 text-indigo-500" />
                    القيم الحالية
                </h3>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full text-sm text-right">
                    <thead class="bg-slate-50 text-slate-600 font-bold border-b border-slate-100">
                        <tr>
                            <th class="px-6 py-4">الايقونة</th>
                            <th class="px-6 py-4">العنوان</th>
                            <th class="px-6 py-4">الوصف</th>
                            <th class="px-6 py-4">الترتيب</th>
                            <th class="px-6 py-4 text-center">الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-50">
                        @forelse($values as $value)
                        <tr class="hover:bg-slate-50/50 transition-colors">
                            <td class="px-6 py-4">
                                <div class="w-10 h-10 bg-blue-50 rounded-lg flex items-center justify-center text-blue-600">
                                    <i class="{{ $value->icon }}"></i>
                                </div>
                            </td>
                            <td class="px-6 py-4 font-bold text-slate-800">{{ $value->title }}</td>
                            <td class="px-6 py-4 text-slate-600">{{ Str::limit($value->description, 50) }}</td>
                            <td class="px-6 py-4 text-slate-600">{{ $value->order }}</td>
                            <td class="px-6 py-4">
                                <div class="flex justify-center gap-2">
                                     <form action="{{ route('admin.cms.values.destroy', $value->id) }}" method="POST" onsubmit="return confirm('هل أنت متأكد من حذف هذه القيمة؟');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="p-2 bg-red-50 text-red-600 rounded-lg hover:bg-red-100 transition-colors" title="حذف">
                                            <x-icon name="Trash" class="h-4 w-4" />
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="5" class="px-6 py-12 text-center text-slate-500">
                                <div class="flex flex-col items-center gap-2">
                                    <x-icon name="Star" class="h-10 w-10 text-slate-300" />
                                    <p>لا توجد قيم مضافة حالياً.</p>
                                </div>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</x-admin-layout>
