<x-admin-layout>
    <x-slot name="header">Contracts</x-slot>
    <div class="mb-6 flex justify-between items-center flex-wrap gap-4">
        <form method="GET" class="flex items-center space-x-2">
            <input type="text" name="search" placeholder="Search contract #..." value="{{ request('search') }}" class="rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
            <select name="status" class="rounded-md border-gray-300 shadow-sm"><option value="all">All Status</option>
                @foreach(['DRAFT','ACTIVE','EXPIRED','CANCELLED'] as $s)<option value="{{ $s }}" {{ request('status') == $s ? 'selected' : '' }}>{{ ucfirst(strtolower($s)) }}</option>@endforeach
            </select>
            <button type="submit" class="px-4 py-2 bg-gray-800 text-white rounded hover:bg-gray-700">Filter</button>
        </form>
        <button onclick="document.getElementById('addContractModal').classList.remove('hidden')" class="px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-700">+ New Contract</button>
    </div>

    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
        <div class="p-6">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50"><tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Contract #</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Customer</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Type</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Value</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Period</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                </tr></thead>
                <tbody class="divide-y divide-gray-200">
                    @forelse($contracts as $contract)
                        <tr>
                            <td class="px-6 py-4 text-sm font-mono text-indigo-600">{{ $contract->contract_number }}</td>
                            <td class="px-6 py-4 text-sm text-gray-900">{{ $contract->customer->name ?? 'N/A' }}</td>
                            <td class="px-6 py-4 text-sm text-gray-500">{{ $contract->type }}</td>
                            <td class="px-6 py-4 text-sm font-medium">{{ number_format($contract->value, 2) }} EGP</td>
                            <td class="px-6 py-4 text-sm text-gray-500">{{ $contract->start_date->format('M d') }} — {{ $contract->end_date->format('M d, Y') }}</td>
                            <td class="px-6 py-4"><span class="px-2 text-xs rounded-full {{ $contract->status === 'ACTIVE' ? 'bg-green-100 text-green-800' : ($contract->status === 'EXPIRED' ? 'bg-red-100 text-red-800' : 'bg-gray-100 text-gray-800') }}">{{ $contract->status }}</span></td>
                        </tr>
                    @empty
                        <tr><td colspan="6" class="px-6 py-4 text-center text-gray-500">No contracts found.</td></tr>
                    @endforelse
                </tbody>
            </table>
            <div class="mt-4">{{ $contracts->withQueryString()->links() }}</div>
        </div>
    </div>

    <div id="addContractModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50" onclick="if(event.target===this)this.classList.add('hidden')">
        <div class="relative top-10 mx-auto p-6 border w-full max-w-lg shadow-lg rounded-md bg-white">
            <h3 class="text-lg font-medium mb-4">New Contract</h3>
            <form method="POST" action="{{ route('admin.contracts.store') }}" class="space-y-4">
                @csrf
                <div><label class="block text-sm font-medium text-gray-700">Customer</label>
                    <select name="customer_id" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                        @foreach(\App\Models\User::orderBy('name')->get() as $user)<option value="{{ $user->id }}">{{ $user->name }}</option>@endforeach
                    </select>
                </div>
                <div><label class="block text-sm font-medium text-gray-700">Type</label>
                    <select name="type" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"><option value="SALE">Sale</option><option value="SERVICE">Service</option><option value="LEASE">Lease</option><option value="MAINTENANCE">Maintenance</option></select>
                </div>
                <div class="grid grid-cols-2 gap-4">
                    <div><label class="block text-sm font-medium text-gray-700">Start Date</label><input type="date" name="start_date" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></div>
                    <div><label class="block text-sm font-medium text-gray-700">End Date</label><input type="date" name="end_date" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></div>
                </div>
                <div><label class="block text-sm font-medium text-gray-700">Value (EGP)</label><input type="number" step="0.01" name="value" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></div>
                <div class="flex justify-end space-x-2">
                    <button type="button" onclick="this.closest('[id]').classList.add('hidden')" class="px-4 py-2 bg-gray-300 rounded">Cancel</button>
                    <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded">Create</button>
                </div>
            </form>
        </div>
    </div>
</x-admin-layout>
