<x-admin-layout>
    <div class="mb-6 flex flex-col md:flex-row justify-between items-center gap-4">
        <div>
            <h2 class="text-2xl font-bold text-slate-800">العملاء</h2>
            <p class="text-slate-500 text-sm">إدارة قاعدة بيانات العملاء ومتابعة تفاعلهم</p>
        </div>
    </div>

    <div class="mb-6 rounded-2xl bg-white p-4 shadow-sm border border-slate-100">
        <form method="GET" action="{{ route('admin.crm.customers.index') }}" class="flex flex-col md:flex-row items-center gap-4">
            <div class="relative flex-1 w-full">
                <x-icon name="Search" class="absolute right-3 top-1/2 -translate-y-1/2 h-5 w-5 text-gray-400" />
                <input type="text" name="search" placeholder="ابحث عن اسم العميل، البريد الإلكتروني أو الهاتف..." value="{{ request('search') }}" class="w-full rounded-xl border-gray-200 pr-10 focus:border-blue-500 focus:ring-blue-500">
            </div>
            <button type="submit" class="w-full md:w-auto inline-flex items-center justify-center rounded-xl bg-slate-800 px-6 py-2.5 text-sm font-semibold text-white shadow-sm hover:bg-slate-700 transition-all">
                <x-icon name="Filter" class="ml-2 h-4 w-4" />
                بحث
            </button>
        </form>
    </div>

    <div class="overflow-hidden rounded-2xl bg-white shadow-sm border border-slate-100">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50/50">
                    <tr>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">الاسم</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">معلومات الاتصال</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">تاريخ الانضمام</th>
                        <th class="px-6 py-4 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">إجراءات</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($customers as $customer)
                        <tr class="hover:bg-slate-50/50 transition-colors">
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex items-center gap-3">
                                    <div class="h-10 w-10 rounded-full bg-blue-50 flex items-center justify-center text-blue-600">
                                        <span class="font-bold text-sm">{{ substr($customer->name ?? 'C', 0, 1) }}</span>
                                    </div>
                                    <div class="text-sm font-bold text-slate-900">{{ $customer->name }}</div>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex flex-col gap-1">
                                    <div class="flex items-center gap-2 text-sm text-slate-600">
                                        <x-icon name="Mail" class="h-3 w-3 text-slate-400" />
                                        <span>{{ $customer->email }}</span>
                                    </div>
                                    <div class="flex items-center gap-2 text-sm text-slate-600">
                                        <x-icon name="Phone" class="h-3 w-3 text-slate-400" />
                                        <span dir="ltr" class="text-right">{{ $customer->phone }}</span>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-slate-500">
                                <div class="flex items-center gap-2">
                                    <x-icon name="Calendar" class="h-4 w-4 text-slate-400" />
                                    <span>{{ $customer->created_at->format('Y-m-d') }}</span>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-left text-sm font-medium">
                                <a href="{{ route('admin.crm.customers.show', $customer->id) }}" class="inline-flex items-center gap-2 px-3 py-1.5 bg-slate-100 text-slate-700 rounded-lg hover:bg-slate-200 transition-colors">
                                    <x-icon name="Eye" class="h-4 w-4" />
                                    <span>عرض الملف</span>
                                </a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="px-6 py-12 text-center text-slate-500">
                                <div class="flex flex-col items-center justify-center">
                                    <div class="h-16 w-16 bg-slate-50 rounded-full flex items-center justify-center mb-4">
                                        <x-icon name="Users" class="h-8 w-8 text-slate-300" />
                                    </div>
                                    <p class="text-lg font-medium">لا يوجد عملاء</p>
                                    <p class="text-sm">لم يتم العثور على أي عملاء في قاعدة البيانات.</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="border-t border-gray-100 bg-gray-50/50 p-4">
            {{ $customers->withQueryString()->links() }}
        </div>
    </div>
</x-admin-layout>
