<x-admin-layout>
    <div class="mb-6 flex flex-col md:flex-row justify-between items-center gap-4">
        <div>
            <h2 class="text-2xl font-bold text-slate-800">ملف العميل: {{ $customer->user->name }}</h2>
            <p class="text-slate-500 text-sm">عرض تفاصيل العميل وسجل نشاطه</p>
        </div>
        <a href="{{ route('admin.crm.customers.index') }}" class="inline-flex items-center gap-2 px-4 py-2 bg-white border border-slate-200 rounded-xl text-slate-600 hover:bg-slate-50 hover:text-slate-800 transition-colors">
            <x-icon name="ArrowRight" class="h-4 w-4" />
            <span>عودة للقائمة</span>
        </a>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Customer Details -->
        <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden h-fit">
            <div class="p-6 border-b border-gray-50 flex flex-col items-center">
                <div class="h-24 w-24 rounded-full bg-blue-50 flex items-center justify-center text-blue-600 mb-4 ring-4 ring-blue-50/50">
                    <span class="text-3xl font-bold">{{ substr($customer->user->name ?? 'C', 0, 1) }}</span>
                </div>
                <h3 class="text-xl font-bold text-slate-800">{{ $customer->user->name }}</h3>
                <p class="text-slate-500 text-sm">{{ $customer->user->email }}</p>
            </div>
            <div class="p-6">
                <h4 class="text-sm font-bold text-slate-900 mb-4 flex items-center gap-2">
                    <x-icon name="User" class="h-4 w-4 text-slate-400" />
                    المعلومات الشخصية
                </h4>
                <div class="space-y-4">
                    <div class="bg-slate-50 p-4 rounded-xl">
                        <label class="text-xs text-slate-400 block mb-1">رقم الهاتف</label>
                        <div class="text-slate-800 font-medium flex items-center gap-2" dir="ltr">
                             <x-icon name="Phone" class="h-4 w-4 text-slate-400" />
                             {{ $customer->user->phone ?? 'غير متوفر' }}
                        </div>
                    </div>
                    <div class="bg-slate-50 p-4 rounded-xl">
                        <label class="text-xs text-slate-400 block mb-1">العنوان</label>
                        <div class="text-slate-800 font-medium flex items-center gap-2">
                            <x-icon name="MapPin" class="h-4 w-4 text-slate-400" />
                            {{ $customer->address ?? 'غير متوفر' }}
                        </div>
                    </div>
                     <div class="bg-slate-50 p-4 rounded-xl">
                        <label class="text-xs text-slate-400 block mb-1">تاريخ الانضمام</label>
                        <div class="text-slate-800 font-medium flex items-center gap-2">
                            <x-icon name="Calendar" class="h-4 w-4 text-slate-400" />
                            {{ $customer->created_at->format('Y-m-d') }}
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Leads Associated -->
        <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden lg:col-span-2">
             <div class="px-6 py-4 border-b border-gray-50 flex justify-between items-center">
                <h3 class="text-lg font-bold text-slate-800 flex items-center gap-2">
                    <x-icon name="Target" class="h-5 w-5 text-blue-600" />
                    الفرص البيعية (Leads)
                </h3>
                <span class="px-2 py-1 bg-blue-100 text-blue-700 rounded-lg text-xs font-bold">{{ $customer->leads->count() }} فرصة</span>
            </div>
            <div class="divide-y divide-gray-100">
                @forelse($customer->leads as $lead)
                <div class="p-6 hover:bg-slate-50 transition-colors">
                    <div class="flex items-start justify-between">
                        <div class="flex items-center gap-3">
                            <div class="h-10 w-10 rounded-lg bg-indigo-50 flex items-center justify-center text-indigo-600">
                                <x-icon name="Zap" class="h-5 w-5" />
                            </div>
                            <div>
                                <h4 class="text-sm font-bold text-slate-900">{{ $lead->first_name }} {{ $lead->last_name }}</h4>
                                <div class="flex items-center gap-2 mt-1">
                                    <span class="text-xs text-slate-500 bg-slate-100 px-2 py-0.5 rounded">المصدر: {{ $lead->source ?? 'غير محدد' }}</span>
                                    <span class="text-xs text-slate-400">•</span>
                                    <span class="text-xs text-slate-400">{{ $lead->created_at->format('Y-m-d') }}</span>
                                </div>
                            </div>
                        </div>
                        <span class="px-3 py-1 inline-flex text-xs leading-5 font-bold rounded-full 
                            {{ $lead->status === 'new' ? 'bg-blue-100 text-blue-700' : 
                               ($lead->status === 'contacted' ? 'bg-yellow-100 text-yellow-700' : 
                               ($lead->status === 'qualified' ? 'bg-emerald-100 text-emerald-700' : 'bg-slate-100 text-slate-700')) }}">
                            {{ $lead->status }}
                        </span>
                    </div>
                </div>
                @empty
                <div class="p-12 text-center text-slate-500">
                    <div class="flex flex-col items-center justify-center">
                        <div class="h-16 w-16 bg-slate-50 rounded-full flex items-center justify-center mb-4">
                            <x-icon name="Inbox" class="h-8 w-8 text-slate-300" />
                        </div>
                        <p class="text-lg font-medium">لا توجد فرص بيعية</p>
                        <p class="text-sm">لم يتم تسجيل أي فرص بيعية لهذا العميل بعد.</p>
                    </div>
                </div>
                @endforelse
            </div>
        </div>
    </div>
</x-admin-layout>
