<x-admin-layout>
    <x-slot name="header">
        Opportunities
    </x-slot>

    <div class="max-w-6xl mx-auto">
        <div class="mb-6 flex justify-between items-center">
             <form method="GET" action="{{ route('admin.crm.opportunities.index') }}" class="flex items-center space-x-2">
                 <select name="status" class="rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                    <option value="all">All Stages</option>
                    <option value="PROSPECTING" {{ request('status') == 'PROSPECTING' ? 'selected' : '' }}>Prospecting</option>
                    <option value="QUALIFICATION" {{ request('status') == 'QUALIFICATION' ? 'selected' : '' }}>Qualification</option>
                    <option value="PROPOSAL" {{ request('status') == 'PROPOSAL' ? 'selected' : '' }}>Proposal</option>
                    <option value="NEGOTIATION" {{ request('status') == 'NEGOTIATION' ? 'selected' : '' }}>Negotiation</option>
                    <option value="CLOSED_WON" {{ request('status') == 'CLOSED_WON' ? 'selected' : '' }}>Closed Won</option>
                    <option value="CLOSED_LOST" {{ request('status') == 'CLOSED_LOST' ? 'selected' : '' }}>Closed Lost</option>
                </select>
                <button type="submit" class="px-4 py-2 bg-gray-800 text-white rounded hover:bg-gray-700">Filter</button>
            </form>
             <button onclick="document.getElementById('createOppModal').classList.remove('hidden')" class="px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-700">Add Opportunity</button>
        </div>

        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 bg-white border-b border-gray-200">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Title</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Customer</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Value</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Stage</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Expected Close</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @forelse($opportunities as $opportunity)
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-medium text-gray-900">{{ $opportunity->title }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm text-gray-900">{{ $opportunity->customerProfile->user->name ?? 'N/A' }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    {{ number_format($opportunity->value, 2) }} EGP
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                                        {{ $opportunity->stage === 'CLOSED_WON' ? 'bg-green-100 text-green-800' : 
                                           ($opportunity->stage === 'CLOSED_LOST' ? 'bg-red-100 text-red-800' : 'bg-blue-100 text-blue-800') }}">
                                        {{ $opportunity->stage }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    {{ $opportunity->expected_close_date ? $opportunity->expected_close_date->format('M d, Y') : 'N/A' }}
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="px-6 py-4 text-center text-gray-500">No opportunities found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
                <div class="mt-4">
                    {{ $opportunities->withQueryString()->links() }}
                </div>
            </div>
        </div>
    </div>

    <!-- Create Opportunity Modal -->
    <div id="createOppModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden">
        <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
            <div class="mt-3 text-center">
                <h3 class="text-lg leading-6 font-medium text-gray-900">Add New Opportunity</h3>
                <form method="POST" action="{{ route('admin.crm.opportunities.store') }}" class="mt-4 text-left">
                    @csrf
                     <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700">Title</label>
                        <input type="text" name="title" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                    </div>
                     <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700">Customer</label>
                        <select name="customer_id" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                             @foreach(\App\Models\CustomerProfile::with('user')->get() as $profile)
                                <option value="{{ $profile->id }}">{{ $profile->user->name }}</option>
                             @endforeach
                        </select>
                    </div>
                     <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700">Value</label>
                        <input type="number" name="value" step="0.01" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                    </div>
                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700">Stage</label>
                        <select name="stage" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                            <option value="PROSPECTING">Prospecting</option>
                            <option value="QUALIFICATION">Qualification</option>
                            <option value="PROPOSAL">Proposal</option>
                            <option value="NEGOTIATION">Negotiation</option>
                        </select>
                    </div>
                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700">Expected Close Date</label>
                        <input type="date" name="expected_close_date" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                    </div>
                    <div class="flex justify-end mt-4">
                        <button type="button" onclick="document.getElementById('createOppModal').classList.add('hidden')" class="mr-2 px-4 py-2 bg-gray-200 text-gray-800 rounded hover:bg-gray-300">Cancel</button>
                        <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-700">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-admin-layout>
