<x-admin-layout>
    <x-slot name="header">Customer Service</x-slot>
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6">
                <h3 class="text-lg font-medium mb-4">Service Metrics</h3>
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50"><tr>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Tickets</th>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Resolved</th>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Satisfaction</th>
                    </tr></thead>
                    <tbody class="divide-y divide-gray-200">
                        @forelse($metrics as $metric)
                            <tr>
                                <td class="px-4 py-3 text-sm text-gray-500">{{ $metric->date->format('M d') }}</td>
                                <td class="px-4 py-3 text-sm">{{ $metric->tickets_received }}</td>
                                <td class="px-4 py-3 text-sm text-green-600">{{ $metric->tickets_resolved }}</td>
                                <td class="px-4 py-3 text-sm">{{ $metric->customer_satisfaction ? number_format($metric->customer_satisfaction, 1) . '%' : 'N/A' }}</td>
                            </tr>
                        @empty
                            <tr><td colspan="4" class="px-4 py-3 text-center text-gray-500">No data yet.</td></tr>
                        @endforelse
                    </tbody>
                </table>
                <div class="mt-4">{{ $metrics->links() }}</div>
            </div>
        </div>
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6">
                <h3 class="text-lg font-medium mb-4">Recent Evaluations</h3>
                <div class="space-y-3">
                    @forelse($evaluations as $eval)
                        <div class="p-3 bg-gray-50 rounded">
                            <div class="flex justify-between"><span class="text-sm font-medium">{{ $eval->customer->name ?? 'Anonymous' }}</span><span class="text-xs text-gray-500">{{ $eval->created_at->diffForHumans() }}</span></div>
                            <div class="text-sm mt-1">Overall: <span class="font-medium">{{ $eval->overall_rating }}/5</span></div>
                            @if($eval->feedback)<div class="text-xs text-gray-500 mt-1">{{ Str::limit($eval->feedback, 80) }}</div>@endif
                        </div>
                    @empty
                        <p class="text-center text-gray-500">No evaluations yet.</p>
                    @endforelse
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
