<x-admin-layout>
    <x-slot name="header">Expenses</x-slot>

    {{-- Stats Cards --}}
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
        <div class="bg-white rounded-lg shadow p-6">
            <div class="text-sm font-medium text-gray-500">Total Expenses</div>
            <div class="text-2xl font-bold text-red-600 mt-1">{{ number_format($stats['total'], 2) }} EGP</div>
        </div>
        <div class="bg-white rounded-lg shadow p-6">
            <div class="text-sm font-medium text-gray-500">This Month</div>
            <div class="text-2xl font-bold text-orange-600 mt-1">{{ number_format($stats['this_month'], 2) }} EGP</div>
        </div>
        <div class="bg-white rounded-lg shadow p-6">
            <div class="text-sm font-medium text-gray-500">Total Entries</div>
            <div class="text-2xl font-bold text-gray-900 mt-1">{{ $stats['count'] }}</div>
        </div>
    </div>

    <div class="mb-6 flex justify-between items-center flex-wrap gap-4">
        <form method="GET" class="flex items-center space-x-2">
            <input type="text" name="search" placeholder="Search expenses..." value="{{ request('search') }}" class="rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
            <select name="category" class="rounded-md border-gray-300 shadow-sm">
                <option value="all">All Categories</option>
                @foreach(['RENT','UTILITIES','SALARIES','SUPPLIES','MARKETING','MAINTENANCE','INSURANCE','OTHER'] as $cat)
                    <option value="{{ $cat }}" {{ request('category') == $cat ? 'selected' : '' }}>{{ ucfirst(strtolower($cat)) }}</option>
                @endforeach
            </select>
            <button type="submit" class="px-4 py-2 bg-gray-800 text-white rounded hover:bg-gray-700">Filter</button>
        </form>
        <button onclick="document.getElementById('addExpenseModal').classList.remove('hidden')" class="px-4 py-2 bg-red-600 text-white rounded hover:bg-red-700">+ Add Expense</button>
    </div>

    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
        <div class="p-6">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">ID</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Description</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Category</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Amount</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Method</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($expenses as $expense)
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-mono text-gray-500">{{ $expense->transaction_id }}</td>
                            <td class="px-6 py-4 text-sm text-gray-900">{{ $expense->description }}</td>
                            <td class="px-6 py-4 whitespace-nowrap"><span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-yellow-100 text-yellow-800">{{ $expense->category ?? 'N/A' }}</span></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-red-600">{{ number_format($expense->amount, 2) }} EGP</td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $expense->created_at->format('M d, Y') }}</td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $expense->payment_method }}</td>
                        </tr>
                    @empty
                        <tr><td colspan="6" class="px-6 py-4 text-center text-gray-500">No expenses found.</td></tr>
                    @endforelse
                </tbody>
            </table>
            <div class="mt-4">{{ $expenses->withQueryString()->links() }}</div>
        </div>
    </div>

    {{-- Add Expense Modal --}}
    <div id="addExpenseModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50" onclick="if(event.target===this)this.classList.add('hidden')">
        <div class="relative top-20 mx-auto p-6 border w-full max-w-md shadow-lg rounded-md bg-white">
            <h3 class="text-lg font-medium text-gray-900 mb-4">Add Expense</h3>
            <form method="POST" action="{{ route('admin.expenses.store') }}" class="space-y-4">
                @csrf
                <div><label class="block text-sm font-medium text-gray-700">Description</label><input type="text" name="description" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50"></div>
                <div><label class="block text-sm font-medium text-gray-700">Amount (EGP)</label><input type="number" step="0.01" name="amount" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50"></div>
                <div><label class="block text-sm font-medium text-gray-700">Category</label>
                    <select name="category" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                        @foreach(['RENT','UTILITIES','SALARIES','SUPPLIES','MARKETING','MAINTENANCE','INSURANCE','OTHER'] as $c)<option value="{{ $c }}">{{ ucfirst(strtolower($c)) }}</option>@endforeach
                    </select>
                </div>
                <div><label class="block text-sm font-medium text-gray-700">Payment Method</label>
                    <select name="payment_method" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                        <option value="CASH">Cash</option><option value="BANK_TRANSFER">Bank Transfer</option><option value="CREDIT_CARD">Credit Card</option>
                    </select>
                </div>
                <div><label class="block text-sm font-medium text-gray-700">Date</label><input type="date" name="date" value="{{ date('Y-m-d') }}" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50"></div>
                <div><label class="block text-sm font-medium text-gray-700">Notes</label><textarea name="notes" rows="2" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50"></textarea></div>
                <div class="flex justify-end space-x-2">
                    <button type="button" onclick="document.getElementById('addExpenseModal').classList.add('hidden')" class="px-4 py-2 bg-gray-300 rounded hover:bg-gray-400">Cancel</button>
                    <button type="submit" class="px-4 py-2 bg-red-600 text-white rounded hover:bg-red-700">Add Expense</button>
                </div>
            </form>
        </div>
    </div>
</x-admin-layout>
