<x-admin-layout>
    <x-slot name="header">Customer Feedback</x-slot>
    <div class="mb-6"><form method="GET" class="flex items-center space-x-2">
        <select name="status" class="rounded-md border-gray-300 shadow-sm"><option value="all">All Status</option>
            @foreach(['PENDING','REVIEWED','RESOLVED'] as $s)<option value="{{ $s }}" {{ request('status') == $s ? 'selected' : '' }}>{{ ucfirst(strtolower($s)) }}</option>@endforeach
        </select>
        <button type="submit" class="px-4 py-2 bg-gray-800 text-white rounded hover:bg-gray-700">Filter</button>
    </form></div>

    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
        <div class="p-6">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50"><tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Customer</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Type</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Rating</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Message</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                </tr></thead>
                <tbody class="divide-y divide-gray-200">
                    @forelse($feedbacks as $fb)
                        <tr>
                            <td class="px-6 py-4 text-sm text-gray-900">{{ $fb->customer->name ?? 'Anonymous' }}</td>
                            <td class="px-6 py-4 text-sm text-gray-500">{{ $fb->type ?? 'General' }}</td>
                            <td class="px-6 py-4 text-sm">
                                @for($i = 1; $i <= 5; $i++)<span class="{{ $i <= ($fb->rating ?? 0) ? 'text-yellow-400' : 'text-gray-300' }}">★</span>@endfor
                            </td>
                            <td class="px-6 py-4 text-sm text-gray-500">{{ Str::limit($fb->message, 50) }}</td>
                            <td class="px-6 py-4 text-sm text-gray-500">{{ $fb->created_at->format('M d') }}</td>
                            <td class="px-6 py-4"><span class="px-2 text-xs rounded-full {{ $fb->status === 'RESOLVED' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' }}">{{ $fb->status ?? 'PENDING' }}</span></td>
                        </tr>
                    @empty
                        <tr><td colspan="6" class="px-6 py-4 text-center text-gray-500">No feedback found.</td></tr>
                    @endforelse
                </tbody>
            </table>
            <div class="mt-4">{{ $feedbacks->withQueryString()->links() }}</div>
        </div>
    </div>
</x-admin-layout>
